#!/usr/bin/env python
# -*- coding: latin-1 -*-
#
# Time-stamp: <2004-07-27 07:11:14 graham>
#
# COPYRIGHT  Togaware 2004 All rights are reserved.
#
# Authors: Graham Williams
#

"""Validate the XML entries that make up the TeX Catalogue."""

import os
import re
import sys
import codecs

from tcutils import commify, list_packages, loadXML

########################################################################
# SYSTEM VARIABLES
#
__version__ = "$Revision: 1.11 $".split()[1]
__verdate__ = "$Date: 2004/07/27 09:46:49 $".split()[1:3]
__source__  = "$Source: /cvsroot/texcatalogue/texcatalogue/src/validate.py,v $".\
              split()[1]
__program__ = re.sub('^.RCSfile: (.*).py,v .', "\\1",
                     "$RCSfile: validate.py,v $")

########################################################################
#
# VALIDATE
#
catfile = "catalogue.xml"

def validate(entries):
    print "Validating specific entries in the Catalogue:"
    progress = ""
    for p in entries:
        #
        # Read in the XML file.
        #
        print p,
        try:
            doc = loadXML(p)
        except Exception, e:
            print e

def full_validate():
    print "Validating full catalogue."
    from xml.dom.ext.reader.Sax import FromXmlFile
    try:
        doc = FromXmlFile(catfile, validate = True)
    except Exception, e:
        print e
        index = int(str(e).split(":")[1])-1
        doc = codecs.open(catfile, "r", "utf-8").readlines()
        if "</fullcat>" not in doc[index]:
            print "Source Line: " + doc[index].strip()
        if "<author " not in doc[index]:
            while "<entry " not in doc[index]: index = index - 1
            print "Entry ID: " + \
                  doc[index].split("id=")[1].strip().replace('>','')

###################################################################
# MAIN PROGRAM
#
def _usage():
    """Print documentation."""
    print __doc__

def _main():
    """Process command line options then perform the action."""
    if len(sys.argv) > 1:
        entries = sys.argv[1:]
        validate(entries)
    else:
        entries = list_packages()
        ecount = commify(len(entries))
        print "The catalogue contains %s entries." % ecount
        full_validate()

########################################################################
#
# INTERACTIVE
#
# Test to see if we are running as a main program, rather than being
# imported as a library. If it's a main program, then let's do some
# work. Otherwise let's quielty proceed.
#
if __name__ == "__main__":
    _main()
