#include "xsltproc.h"

#include <iostream>
#include <qmessagebox.h>

#include "process.h"


XSLTProc::XSLTProc ()
{
	xsltprocessor="xsltproc";
	showOutput=false;
	dia=new ShowTextDialog;
}

XSLTProc::~XSLTProc ()
{
	delete (dia);
}

void XSLTProc::addStringParam (const QString & k, const QString &v)
{
	stringParamKey.append (k);
	stringParamVal.append (v);
}

void XSLTProc::setOutputFile    (const QString &s)
{
	outputFile=s;
}

void XSLTProc::setXSLFile(const QString &s)
{
	xslFile=s;
}

void XSLTProc::setInputFile     (const QString &s)
{
	inputFile=s;
}

void XSLTProc::addOutput (const QString &s)
{
	dia->append (s);
}

void XSLTProc::process()
{
	ShowTextDialog dia;
	Process *xsltProc=new Process ();
	xsltProc->clearArguments();
	xsltProc->addArgument (xsltprocessor);	

	QStringList::Iterator itk;
	QStringList::Iterator itv=stringParamVal.begin();

	for ( itk = stringParamKey.begin(); itk != stringParamKey.end(); ++itk ) 
	{
		xsltProc->addArgument ("--stringparam");
		xsltProc->addArgument (*itk);
		xsltProc->addArgument (*itv);
		++itv;
    }
	
	xsltProc->addArgument ("--output");
	xsltProc->addArgument (outputFile);
	xsltProc->addArgument (xslFile);
	xsltProc->addArgument (inputFile);
	dia.append ("vym is executing: \n" + xsltProc->arguments().join(" ") );	
	if (!xsltProc->start() )
	{
		QMessageBox::critical( 0, QObject::tr( "Critical Error" ),
					   QObject::tr("Could not start %1").arg(xsltprocessor) );
	} else
	{
		xsltProc->waitFinished();
		if (!xsltProc->normalExit() )
			QMessageBox::critical( 0, QObject::tr( "Critical Error" ),
			   QObject::tr("%1 didn't exit normally").arg(xsltprocessor) +
			   xsltProc->getErrout() );
		else
			if (xsltProc->exitStatus()>0) showOutput=true;
			
	}	
	dia.append ("\n");
	dia.append (xsltProc->getErrout());
	dia.append (xsltProc->getStdout());
	
	if (showOutput) dia.exec();
}

