/*  Festalon - NSF Player
 *  Copyright (C) 2002 Ben Parnell
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <string.h>
#include <stdlib.h>

#include "types.h"
#include "x6502.h"
#include "cart.h"

/* 
   This file contains all code for coordinating the mapping in of the
   address space external to the NES.
   It's also (ab)used by the NSF code.
*/

/* 16 are (sort of) reserved for UNIF/iNES and 16 to map other stuff. */
uint8 *Page[32];
static int PRGram[32];
uint8 *PRGptr[32];
uint32 PRGsize[32];
uint32 PRGmask4[32];

static INLINE void setpageptr(int s, uint32 A, uint8 *p)
{
 uint32 AB=A>>11;
 int x;

 for(x=(s>>1)-1;x>=0;x--)
  Page[AB+x]=p-A;
}

static char nothing[2048];
void ResetCartMapping(void)
{
 int x;

 for(x=0;x<32;x++)
 {
  Page[x]=nothing-x*2048;
  PRGptr[x]=0;
  PRGsize[x]=0;
 }
}

void SetupCartPRGMapping(int chip, uint8 *p, uint32 size, int ram)
{
 PRGptr[chip]=p;
 PRGsize[chip]=size;

 PRGmask4[chip]=(size>>12)-1;
 PRGram[chip]=ram?1:0;
}

DECLFR(CartBR)
{
 return Page[A>>11][A];
}

static void INLINE setprg4r(int r, unsigned int A, unsigned int V)
{
  if(!PRGptr[r]) return;
  V&=PRGmask4[r];
  setpageptr(4,A,(&PRGptr[r][V<<12]));
}

void FASTAPASS(2) setprg4(uint32 A, uint32 V)
{
 setprg4r(0,A,V);
}
