/**/


#include "blankscrn.moc"


#include <stdlib.h>
#include <iostream>
#include <qlabel.h>
#include <qlayout.h>
#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>
#include <kglobal.h>
#include "blankscrn.h"

#include <qpainter.h>
#include <qcolor.h>


// libkscreensaver interface
extern "C"
{
    const char *kss_applicationName = "ksetisaver";
    const char *kss_description = I18N_NOOP( "Seti@home" );
    const char *kss_version = "2.2.0";

    KScreenSaver *kss_create( WId id )
    {
        return new KBlankSaver( id );
    }

    QDialog *kss_setup()
    {
				KGlobal::locale()->insertCatalogue("ksetisaver");
				//return new ConfigDialog();
				return new configDialogR2Impl();
    }
}



KBlankSaver::KBlankSaver( WId id ) : KScreenSaver( id )
{

  speed = 1000;
	conf = new configuration();
	conf->readConfig();

	int w = this->width();
	int h = this->height();
	
	int ox,oy;
	if (conf->isManualPositioning()) {
  	ox = conf->getManX();
		oy = conf->getManY();
	}
	else {
  	ox = (w-1024)/2;
  	oy = (h- 768)/2;
	}
	
	//QWidget bg;
	bg.setBackgroundColor(Qt::black);
	bg.setFixedSize(w,h);
  //cout << "Test: " << KApplication::kApplication()->kdedir() << endl;
	
  drawingArea = new QWidget(&bg);
	drawingArea->setBackgroundColor(Qt::black);
	drawingArea->setFixedSize(1024,768);
	

	drawingArea->setGeometry(ox,oy,1024,768);

  embed(&bg);
	bg.show();

	mp = new mainPainter(conf);

	timer.start( speed );
	connect( &timer, SIGNAL( timeout() ), SLOT( slotTimeout() ) );
  //topLevelWidget()->showFullScreen();
}

KBlankSaver::~KBlankSaver()
{
	 delete mp;
	 delete conf;
}


void KBlankSaver::slotTimeout() {
	
		timer.stop();
		QPainter p(drawingArea);
	 	//QPainter p(this);

		//speed = mp.paint(&p, &mw, &timer);	
	  speed = mp->paint(&p, this, &timer);	
		timer.start (speed);
}

