/***************************************************************************
                          painthelpers.h  -  description
                             -------------------
    begin                : Thu Jan 3 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PAINTHELPERS_H
#define PAINTHELPERS_H

#include <unistd.h>
//#include <string.h>
#include <math.h>

#include <qpainter.h>
#include <qcolor.h>
#include <qstring.h>
#include <qfont.h>
#include <qpainter.h>
#include <qfontmetrics.h>
#include <qpixmap.h>
#include <qpen.h>

#include "setiparse.h"
#include "configuration.h"
#include "soundbox.h"

/**
  *@author Sebastian Schildt
  */

class paintHelpers {
public: 
	paintHelpers(const configuration *conf);
	~paintHelpers();	
	void drawBottomLine(QPainter *p,QString bottom);
	void drawSkymap(QPainter *p);
  void drawMainHeader(QPainter *p,QString head, QColor col);
  void drawMainHeader(QPainter *p,QString head);
  void clearScreen(QPainter *p);
	void skymapData(int i, QPainter *p, setiparse *s);

	QFont headerfont;
	QFont smallFont, mediumFont;

	QColor lcarsOrange, lcarsLila;
	QColor black;
	QColor lgray, dgray,white;
	
  QPixmap skymap;

	SoundBox *sound;

private:
	

	QString RA2String(double ra);
	QString DEC2String(double ra);
	
};
 	

#endif
