package org.apache.lucene.search;

/**
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import junit.framework.TestCase;

import java.util.Vector;

import org.apache.lucene.index.Term;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

/** Similarity unit test.
 *
 * @author Doug Cutting
 * @version $Revision: 1.3 $
 */
public class TestNot extends TestCase {
  public TestNot(String name) {
    super(name);
  }

  public void testNot() throws Exception {
    RAMDirectory store = new RAMDirectory();
    IndexWriter writer = new IndexWriter(store, new SimpleAnalyzer(), true);

    Document d1 = new Document();
    d1.add(Field.Text("field", "a b"));

    writer.addDocument(d1);
    writer.optimize();
    writer.close();

    Searcher searcher = new IndexSearcher(store);
    Query query = QueryParser.parse("a NOT b", "field", new SimpleAnalyzer());
    //System.out.println(query);
    Hits hits = searcher.search(query);
    assertEquals(0, hits.length());
  }
}
