/* This file is part of q-tools, a collection of performance tools
   Copyright (c) 2003 Hewlett-Packard Development Company, L.P.
   Contributed by David Mosberger-Tang <davidm@hpl.hp.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA  02111-1307  USA  */

#ifndef call_counts_h
#define call_counts_h

#include <stdint.h>

#include <sys/types.h>

struct call_count;

extern struct call_count *call_count_create (void);
extern void call_count_add (struct call_count *, uintptr_t, uintptr_t, size_t);
extern int call_count_extract (struct call_count *,
			       int (*callback) (void *, uintptr_t, uintptr_t,
						size_t count),
			       void *arg);
extern void call_count_destroy (struct call_count *);

#endif /* call_counts_h */
