\name{getSelectedIndices.ggobi}
\alias{getSelectedIndices.ggobi}
\alias{isObservationSelected.ggobi}
\title{Computes which records are selected in a ggobi instance}
\description{
  The user can select different records in a ggobi dataset
 using the brushing region.
  These functions provide two ways to query
 the set of selected observations.
  One (\code{getSelectedIndices.ggobi}) returns the indices of the selected records.
The other is a simple transformation of this information
which indicates, via a logical vector, for  each  record
whether it is currently selected.
}
\usage{
getSelectedIndices.ggobi(.data = 1, .gobi=getDefaultGGobi())
isObservationSelected.ggobi(.data = 1, .gobi=getDefaultGGobi())
}
\arguments{
  \item{.data}{the dataset whose selected status is to be queried.
  This can be any identifier for a dataset, specifically a name, index
or an object of class \code{ggobiDataset}.}
  \item{.gobi}{an identifier for the ggobi instance in which the dataset
to be queried resides. This is either an index or an object of class
\code{ggobi}. This is not necessary if the \code{.data} argument
is supplied in the form of an object of class \code{ggobiDataset}.}
}
\value{
\code{getSelectedIndices.ggobi} returns
an integer vector containing the indices of the records
in the specified dataset that are currently selected.

\code{isObservationSelected.ggobi}
returns  a logical vector the length of which is the number 
of records in the specified dataset and in which
each element indicates whether the corresponding record 
is currently selected.
}
\references{\url{http://www.ggobi.org/RSggobi.html}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{setBrushLocation.ggobi}}
\code{\link{setBrushSize.ggobi}}
\code{\link{getBrushLocation.ggobi}}
\code{\link{getBrushSize.ggobi}}
}

\examples{

}
\concept{visualization}
\concept{interactive graphics}
\keyword{dynamic}
\keyword{iplot}
