\name{addColorScheme}
\alias{addColorScheme}
\title{Adds a color scheme to a GGobi instance or the global color
  scheme list.}
\description{
  This takes an R color scheme description and
  adds an equivalent representation to
  either the color schemes available to a particular GGobi instance
  or to the global list of color schemes within a GGobi session.
}
\usage{
addColorScheme(scheme, name, overwrite=FALSE, set=FALSE, .gobi=NULL)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{scheme}{the \code{ColorScheme} object. }
  \item{name}{the name to identify/describe the scheme.}
  \item{overwrite}{a logical value indicating whether
    we should replace any existing entry with this name
    with the new scheme (\code{TRUE}), or simply append
    the new scheme to the end of the list.}
  \item{set}{a logical value that indicates whether
    to also make this the active color scheme.
    See \code{setActiveColorScheme}.}
  \item{.gobi}{the GGobi instance to which to append the new
    color scheme, or if this is \code{NULL},
    the color scheme is added to the session options and
   will be available to new GGobi instances created after this.}
}
\value{
  The index/position in the appropriate
  list of color schemes to which the
  new scheme was added.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
 \code{\link{setActiveColorScheme}}
 \code{\link{getColorSchemes}}  
}

\examples{

 data(mtcars)

 g = ggobi(mtcars)
 cs = getColorSchemes()
 cs[[1]]@name
 addColorScheme(cs[[1]], "Debby")

 g = ggobi(mtcars)
 cs.new = getColorSchemes()
 length(cs.new) == length(cs) + 1


  
 g = ggobi(mtcars)
 cs = getColorSchemes()[[1]]
 addColorScheme(cs, "Duncan", .gobi = 1)
}
\concept{visualization}
\concept{interactive graphics}
\keyword{dynamic}

