\name{getDefaultGGobi}
\alias{getDefaultGGobi}
\alias{setDefaultGGobi}

\title{Identifies the active/default ggobi instance}
\description{
 There can be multiple concurrent ggobi instances within an R session.
 One of them acts as the default to which commands are
 sent if the instance is not explicitly identified within
 the call (via the .gobi argument).
 \code{getDefaultGGobi} functions identifies the index of the instance which is the default.
 \code{setDefaultGGobi} tells the system which instance to treat as the default.
}
\usage{
 getDefaultGGobi()
 setDefaultGGobi(which)
}
\arguments{
 \item{which}{The index  of the ggobi instance which is
  to become the default. This should be an integer
  between 1 and the value of \code{\link{getNumGGobis}}}
}

\value{
 An integer vector of length 1.
}

\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{\code{\link{setDefaultGGobi}},
\code{\link{ggobi}}
}


\examples{
  # Create two ggobi instances
  # and find out which is default
  ggobi()
  ggobi()
  getDefaultGGobi()
  setDefaultGGobi(1)
  getDefaultGGobi()
}
\concept{visualization}

\keyword{programming}
\keyword{device}
