/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Fernando Nasser
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.explain;

/**
 * The listener interface for receiving Explain events. Methods
 * wanting to recieve notification of {@link ExplainEvent
 * ExplainEvents} should implement this interface and register
 * themselves with {@link Explain} objects.
 *
 * @author <a href="mailto:fnasser@redhat.com">Fernando Nasser</a>
 * @version 0.0
 */

public interface ExplainListener extends java.util.EventListener {
	/**
	 * Called when a SQL EXPLAIN command will be run or has finished.
	 *
	 * @param e a <code>ExplainEvent</code> value
	 */
	public void statusChanged(ExplainEvent e);
}// ExplainListener
