/* ================================================================
 * JCommon : a general purpose, open source, class library for Java
 * ================================================================
 *
 * Project Info:  http://www.object-refinery.com/jcommon/index.html
 * Project Lead:  David Gilbert (david.gilbert@object-refinery.com);
 *
 * (C) Copyright 2000-2002, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * ----------------------
 * AboutResources_pl.java
 * ----------------------
 * (C) Copyright 2002, by Simba Management Limited.
 *
 * Original Author:     David Gilbert (for Simba Management Limited);
 * Polish translation:  Krzysztof Pa (kpaz@samorzad.pw.edu.pl);
 *
 * $Id: AboutResources_pl.java,v 1.1 2002/06/07 13:57:57 mungady Exp $
 *
 * Changes
 * -------
 * 15-Mar-2002 : Version 1 (DG);
 *
 */

package com.jrefinery.ui.about.resources;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import java.util.ListResourceBundle;

/**
 * A resource bundle that stores all the user interface items that might need localisation.
 */
public class AboutResources_pl extends ListResourceBundle {

    /**
     * Returns the array of strings in the resource bundle.
     */
    public Object[][] getContents() {
        return contents;
    }

    /** The resources to be localised. */
    static final Object[][] contents = {

        {"about-frame.tab.about",             "Informacja o"},
        {"about-frame.tab.system",            "System"},
        {"about-frame.tab.contributors",      "Twrcy"},
        {"about-frame.tab.licence",           "Licencja"},
        {"about-frame.tab.libraries",         "Biblioteki"},

        {"contributors-table.column.name",    "Nazwa:"},
        {"contributors-table.column.contact", "Kontakt:"},

        {"libraries-table.column.name",       "Nazwa:"},
        {"libraries-table.column.version",    "Wersja:"},
        {"libraries-table.column.licence",    "Licencja:"},
        {"libraries-table.column.info",       "Inne informacje:"},

        {"system-frame.title",                "Waciwoci systemowe"},

        {"system-frame.button.close",         "Zamknij"},
        {"system-frame.button.close.mnemonic", new Character('Z')},

        {"system-frame.menu.file",                "Plik"},
        {"system-frame.menu.file.mnemonic",       new Character('P')},

        {"system-frame.menu.file.close",          "Zamknij"},
        {"system-frame.menu.file.close.mnemonic", new Character('K')},

        {"system-frame.menu.edit",                "Edycja"},
        {"system-frame.menu.edit.mnemonic",       new Character('E')},

        {"system-frame.menu.edit.copy",           "Kopiuj"},
        {"system-frame.menu.edit.copy.mnemonic",  new Character('C')},

        {"system-properties-table.column.name",   "Nazwa waciwoci:"},
        {"system-properties-table.column.value",  "Warto:"},

        {"system-properties-panel.popup-menu.copy", "Kopiuj" },
        {"system-properties-panel.popup-menu.copy.accelerator",
                            KeyStroke.getKeyStroke(KeyEvent.VK_C, ActionEvent.CTRL_MASK) },

    };

}