

#define LIVEICE_VERSION "1.1"


#define AJ_ENCODER       1
#define L3ENC            2
#define MP3ENC           3
#define BLADEENC         4
#define ENC_8HZ          5
#define SCREAMER         7
#define XING             8
#define XING_VBR         9
#define XING_BETA        10
#define LAME3            11
#define LAME31x          12
#define OLD_LAME3        13

#define DEFAULT_ENCODER LAME3

#define MAX_ENCODER_STREAMS 8

/* login formats */
#define ICY_LOGIN          0
#define X_AUDIOCAST_LOGIN  1

/* Default port */
#define PORT 8000



#define MP_BUFF_SIZE 4096  /* make sure this is large enough */


/* Magic numebrs for random number generator */
/* probably not used */

#define RAND_MOD  714025
#define RAND_MULT 4096
#define RAND_ADD  150889


/* a load of #defines for states */
#define CONNECTION_INIT 0 /* plugin has just been loaded nothing initialised */
#define CONNECTION_UNABLE -1 /* connection attempt made but rejected */
#define CONNECTION_REFUSED -2 /* remote server refused connection */
#define CONNECTION_DISCONNECT -3 /* set after a connection has been dropped */
#define CONNECTION_OK 1 /* connection to remote server running */

/*  same for the encoder */
#define ENCODER_INIT 0 /* plugin loaded - not initialised */
#define ENCODER_NOTFOUND -1 /* tried execing binary - not found */
#define ENCODER_INVALID -2 /* the encoder doesn't look like it's supported */
#define ENCODER_PANIC -3 /* encoder has died too often or hasn't done anything*/
#define ENCODER_ERROR -4 /* set when a read or write fails */
#define ENCODER_OK 1 /* encoder executed and behaving so far */

/* now the send_enabled field */
#define SEND_INIT 0
#define SEND_ERROR -1 /* for an error that the system can try to recover from*/
/* e.g a dropped connection of random encoder crash */
#define SEND_UNRECOVERABLE -2 /* for an error which can't be fixed */ 
#define SEND_RESTART_ENC -3 /* force a restart of the encoder for new params */
#define SEND_RESTART_ALL -4 /* restart everything */
#define SEND_SHUTDOWN_RQST -5  /* shutdown encoder and link and return to init state*/
#define SEND_SHUTDOWN -6 /* after the server is actually shutdown */
#define SEND_OK 1



typedef struct {
	int port;
	char *server;
        char *password;
        char *mountpoint;
        char *name;
        char *genre;
        char *url;
        char *description;
	char *sound_pipe;     /* name of pipe for sound processing */
        char *mpeg_pipe;      /* name of file used to store header */
        char *encoder_cmd;    /* possible string pointing to encoder bin */
        char *recording_file; /* recording file */
        char *remote_dumpfile; /* remote dumpfile */
	char *encoder_path;
	int public;
        int bitrate;
        int vbr_quality;
        int encoding_quality;
        int sample_rate;
        int channels;
        int header_format;
        int title_streaming;
        int copyright;
        int encoder;           /* enumed variable */
        int remote_dumpfile_enable;

	int read_fd;
	int write_fd;
	int send_fd;

	int send_enabled;

        int encoder_active;
        int connection_active;
        /* some more connection status stuff */
        unsigned long bytes_encoded;
        unsigned long bytes_sent;
  int active; /* set every time bytes are sent to  the system */
              /* periodically checked by the timeout */
        pid_t enc_pid; 

  

	
} lv_struct;


lv_struct lv_conf;

void liveice_about(void);
void liveice_configure(void);
void convert_audio(short *in,short *out,int ch1,int ch2,int n1,int n2);
