<?php

class http {

function redirect($url) {
	$url = http::absoluteUrl($url);
	header("Location: " . $url);
	echo "redirecting to: <a href='". $url . "'>$url</a>"; // just in case browser is fucked.
}

 /**
  * returns an absolute URL, regardless of what kind is passed in.
  * http redirect technically requires an absolute URL, although in 
  * practice most browsers support redirects with just a path and not
  * the full protocal://server:port/path  
  */
function absoluteUrl($url) {
	if ( isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] == "on") {
		$protocal = "https://";
		$goodport = "443";
		$badprotocal = "http://";
	}
	else {
		$protocal = "http://";
		$goodport = "80";
		$badprotocal = "https://";
	}

	if (isset($_SERVER["SERVER_PORT"]) && $_SERVER["SERVER_PORT"] != $goodport)
		$port = ":" . $_SERVER["SERVER_PORT"];
	else
		$port = "";

	if (http::startsWith($url, $protocal)) {
		return $url;
	}
	elseif (http::startsWith($url, $badprotocal)) {
		return $url; // that is ok, i guess
	}
	elseif (http::startsWith($url, "/")) {
		return $protocal . $_SERVER['HTTP_HOST'] . $port . $url ;
	}
	else {
		$ret = $protocal . $_SERVER['HTTP_HOST'] . $port;

		if ( dirname($_SERVER['PHP_SELF']) != "/" )
			$ret .= dirname($_SERVER['PHP_SELF']) . "/" . $url;
		else
			$ret .= "/" . $url;

		return $ret;
	}
}


function startsWith($haystack, $needle) {
	return preg_match("'^" . addslashes($needle). "'",$haystack);
}
			
}
return;
?>
