<?php

// 
// This file is the front door entry point to all pages.
//

require_once('debug.php');
require_once('common.php');
require_once('Lang.php');
require_once('Page.php');
require_once('PageStore.php');
require_once('UserStore.php');
require_once('Properties.php');
require_once('Auth.php');
require_once('Renderer.php');
require_once('PageNav.php');
require_once('Search.php');
require_once('HttpUtil.php');

$prop     = new Properties(get_site_config());
$root 	  = $prop->getGlobal('siteroot');
$docroot  = $prop->getGlobal('sitedocroot');
$robot    = is_robot();    // true if being crawled
$static   = false;         // true iff we are making a static copy.

// this call must be before any pages are created
Lang::init( $prop->getGlobal('default-lang'), split(' ',$prop->getGlobal('languages')) );

$ps       = PageStoreFactory::create($prop->getGlobal('pagebackend'),$prop);
$page     = $ps->getPage($_SERVER['REQUEST_URI']);
$renderer = new Renderer($prop);
$nav      = new PageNav($prop);
$users    = UserStoreFactory::create($prop->getGlobal('userbackend'));
$auth     = new Auth($users,'authenticate');
$search   = new Search(IndexFactory::create($prop->getGlobal('indexbackend')));

$action	    = get('a',get('action','view'));
$authaction = get('auth','');
$query      = preg_replace("'.*\?(.*)$'",'$1',$_SERVER['REQUEST_URI']);

if ($page->fnf) {
	$path = $search->findClosestPage($page->path);
	if ($path) {
		$redirectpage = $ps->getPage($path);
		if ($redirectpage->fnf) {
			$search->deIndexPage($redirectpage);
		}
		http::redirect("$root$path");
	}
	else {
		$renderer->displayFnf($page);
	}
	return;
}

if ($action == 'style') {
	$renderer->style($page); // style does not require auth
	return;
}

$auth->init();
if ($authaction == 'logout') {
	startsession();
	$auth->logout();
}
elseif ($authaction == 'login') {
	startsession();
	$ok = $auth->login($error);
	if ($ok) {
		// continue on with any remaining actions...
	}
	elseif(!$ok) {
		$renderer->display('login', $auth->getLoginForm($prop->getGlobal('sitename'), $error));
		return;
	}
}

if (!$page->may('anonymous',$action)) {
	startsession();
	$username = $auth->username();
	if ($username == '') {
		$renderer->display('login', $auth->getLoginForm($prop->getGlobal('sitename')));
		return;
	}
	elseif (!$page->may($username,$action)) {
		$renderer->displayError('Permission Denied', 'You do not have permission to do that');
		return;
	}
}

## LANGUAGE ##

if (isset($_REQUEST['lang'])) {
	startsession();
	Lang::set($_REQUEST['lang']);
}
else {
	startsession();
}

## EDITOR ##

if ($action == 'edit' || $query == 'edit') {
	startsession();
	require_once("Editor.php");
	$editor = new Editor($prop);
	$edit_action = get('eaction',get('ea','edit'));
	$action = $editor->handleRequest($page,$edit_action);
	if ($action == '')
		return; // $editor handled the request and finished
}

## SEARCH ##

$s = get('s');
if ($s) {
	$result = $search->findByContent($s,$ps);
	if ($result == '')
		$result = _("no search results found.");
	$renderer->renderPage($page,false,$result,true);
	return;
}

## ACTIONS ##

if ($action == 'source') {
	echo "<pre>";
	echo htmlspecialchars($page->get('content'));
	echo "</pre>";
}
elseif($action == 'print') {
	$renderer->renderPage($page,true);
}
elseif ($action == 'view') {
	if ($page->static) {
		require_once('Cache.php');
		$cache = new Cache($prop->getGlobal('cachedir'), $prop->getGlobal('siteroot'));
		if ($cache->time($page->path) < $page->mtime) {
			$cache->begin($page->path);
				$renderer->renderPage($page);
			$cache->end();
		}
		$cache->echofile($page->path);
	}
	else {
		# dynamic module code here...
	}
}
elseif ( $action == 'changes' ) {
	require_once 'Changes.php';
	$changes = new Changes($page,$search);
	if (get('mode') == 'rss') {
		header("Content-type: text/xml");
		echo $changes->resultsRSS($pages,$ps);
	}
	else {
		$html = $changes->results($pages,$ps);
		$renderer->renderPage(&$page,false,$html,true);
	}
	return;
}
else {
	die("an error occurred: unknown action $action");
}

/// functions ///

// so we only call session_start() once
function startsession() {
	static $ses_set = false;
	if (!$ses_set) {
		session_start();
		Lang::priority(); // make sure our new session includes 'lang'
		$ses_set = true;
	}
}

function is_robot() {
	$agent = strtolower($_SERVER['HTTP_USER_AGENT']);
	return preg_match('/^wget|^googlebot/',$agent);
}
  
return;
?>
