/* ancestry.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__ANCESTRY_H
#define INCLUDE__LIBARCH__ANCESTRY_H


#include "libawk/relational.h"
#include "libarch/archive.h"
#include "libarch/project-tree.h"


#define ARCH_ANCESTRY_VERSION_BAZ_1 "arch ancestry version 1"
#define ARCH_ANCESTRY_PATCH_PREFIX "arch:patch:"
#define ARCH_ANCESTRY_PATCH_PARTIAL "PARTIAL"


extern rel_table arch_trace_ancestry (struct arch_archive * arch, t_uchar * archive, t_uchar * revision, int merges);
extern rel_table patch_ancestry (struct arch_project_tree *optional_tree, t_uchar const * patch_id, int minimum_depth, int soft_errors);
extern void ancestry_write (rel_table ancestry, int fd, int maxmimum_length);
extern void ancestry_upload_patch (struct arch_archive * arch, t_uchar const *fqrevision, int max_depth);
extern void ancestry_upload_branch (struct arch_archive * arch, t_uchar const *fqrevision, int max_depth);
extern t_uchar * arch_patch_ancestor (t_uchar const * patch_id, int soft_errors, int cached_only);
#endif  /* INCLUDE__LIBARCH__ANCESTRY_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (ancestry.h)
 */
