/*
 * part of bidwatcher
 * Author: Jan Starzynski
 * use of this code is restricted to the terms
 * of the GNU GPL, which should have been included in this
 * distribution. If not, see www.gnu.org/copyleft/gpl.html.
 * Here is the short version:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * $Id: bidgui.h,v 1.1.2.5 2004/08/25 07:45:07 sturnus Exp $
 *
 * View and Control for Bidgroups
 */

#ifndef BIDWATCHER_BIDGUI_H
#define BIDWATCHER_BIDGUI_H

#include "config.h"

#include <gdk/gdk.h>
#include <gdk/gdkprivate.h>
#include <gtk/gtk.h>

#include "bidwatcher.h"
#include "bidgroup.h"

class SetBidGroupAuction  {
  struct auctioninfo **auction;
  int auc_num;
  int ebay_offset;
  const char *auth_id;
public:
  SetBidGroupAuction(struct auctioninfo *auction[], int auc_num, int ebay_offset, const char *auth_id):
    auction(auction),
    auc_num(auc_num),
    ebay_offset(ebay_offset),
    auth_id(auth_id)
  {}

  ~SetBidGroupAuction();
};

void removeAscii127(char *info);

BidGroup *getBidGroup();
void switchBidGroup(struct auctioninfo *auction[], int auc_num, int current_auc, int new_auc,
                    const char *subdir, int time_diff, const char *auth_id);
void delBidGroupItem(struct auctioninfo *auction[], int auc);
char *configFileName(char *file, const char *subdir, const char *fname);
char *bidGroupFile(char *file, const char *subdir);
void writeBidGroup(const char *subdir);
void readBidGroup(const char *subdir);
void bidGroupComment(char **str, struct auctioninfo *auction[], int auc);
void setBidGroupAuction(struct auctioninfo *auction[], int auc_num, const char *auth_id);
void savePage(const char *page, const char *format, ...);
void addItemsFromFile(const char *subdir, volatile bool &up_in_prog);
void setBid(struct auctioninfo *auction, float bid, int quantity, bool snipe, bool fire_bid);

#endif

