// Interp.C  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "Macros.H"
#include "Commands.H"
#include "Interp.H"
#include "BotInterp.H"

#include <guile/gh.h>
#include <libguile.h>

Bot * Interp::bot = 0;
#ifdef MULTITHREAD
pthread_mutex_t Interp::mutex = PTHREAD_MUTEX_INITIALIZER;
#endif

typedef SCM (*SCMFunc)(...);

SCM
gh_apply_wrapper(void *data)
{
  struct wrapper_data * wd = (struct wrapper_data *)data;
  gh_apply(wd->func, wd->args);
  return SCM_BOOL_T;
}

void
Interp::Startup()
{
//  scm_primitive_load_path(scm_makfrom0str("ice-9/boot-9.scm"));

  gh_new_procedure("bot-action", (SCMFunc)ScriptCommands::Action, 2, 0, 0);
  gh_new_procedure("bot-adduser", (SCMFunc)ScriptCommands::Action, 2, 0, 0);
  gh_new_procedure("bot-addserver", (SCMFunc)ScriptCommands::Action, 3, 4, 0);
  gh_new_procedure("bot-addshit", (SCMFunc)ScriptCommands::Action, 4, 1, 0);
  gh_new_procedure("bot-ban", (SCMFunc)ScriptCommands::Action, 2, 0, 0);
  gh_new_procedure("bot-cycle", (SCMFunc)ScriptCommands::Action, 1, 0, 0);
  gh_new_procedure("bot-deban", (SCMFunc)ScriptCommands::Deban, 2, 0, 0);
  gh_new_procedure("bot-delserver", (SCMFunc)ScriptCommands::DelServer, 1, 0, 0);
  gh_new_procedure("bot-deluser", (SCMFunc)ScriptCommands::DelUser, 2, 0, 0);
  gh_new_procedure("bot-delshit", (SCMFunc)ScriptCommands::DelShit, 2, 0, 0);
  gh_new_procedure("bot-deop", (SCMFunc)ScriptCommands::Deop, 2, 0, 0);
  gh_new_procedure("bot-die", (SCMFunc)ScriptCommands::Die, 1, 0, 0);
  gh_new_procedure("bot-do", (SCMFunc)ScriptCommands::Do, 1, 0, 0);
  gh_new_procedure("bot-invite", (SCMFunc)ScriptCommands::Invite, 2, 0, 0);
  gh_new_procedure("bot-join", (SCMFunc)ScriptCommands::Join, 1, 1, 0);
  gh_new_procedure("bot-keep", (SCMFunc)ScriptCommands::Keep, 2, 0, 0);
  gh_new_procedure("bot-kick", (SCMFunc)ScriptCommands::Kick, 2, 1, 0);
  gh_new_procedure("bot-kickban", (SCMFunc)ScriptCommands::KickBan, 2, 1, 0);
  gh_new_procedure("bot-lock", (SCMFunc)ScriptCommands::Lock, 1, 0, 0);
  gh_new_procedure("bot-logport", (SCMFunc)ScriptCommands::LogPort, 0, 0, 0);
  gh_new_procedure("bot-mode", (SCMFunc)ScriptCommands::Mode, 2, 0, 0);
  gh_new_procedure("bot-msg", (SCMFunc)ScriptCommands::Msg, 2, 0, 0);
  gh_new_procedure("bot-nextserver", (SCMFunc)ScriptCommands::NextServer, 0, 0, 0);
  gh_new_procedure("bot-nick", (SCMFunc)ScriptCommands::Nick, 1, 0, 0);
  gh_new_procedure("bot-op", (SCMFunc)ScriptCommands::Op, 2, 0, 0);
  gh_new_procedure("bot-part", (SCMFunc)ScriptCommands::Part, 1, 0, 0);
  gh_new_procedure("bot-reconnect", (SCMFunc)ScriptCommands::Reconnect, 0, 0, 0);
  gh_new_procedure("bot-say", (SCMFunc)ScriptCommands::Say, 2, 0, 0);
  gh_new_procedure("bot-server", (SCMFunc)ScriptCommands::Server, 1, 0, 0);
  gh_new_procedure("bot-setversion", (SCMFunc)ScriptCommands::SetVersion, 1, 0, 0);
  gh_new_procedure("bot-tban", (SCMFunc)ScriptCommands::TBan, 3, 0, 0);
  gh_new_procedure("bot-tkban", (SCMFunc)ScriptCommands::TKBan, 3, 1, 0);
  gh_new_procedure("bot-topic", (SCMFunc)ScriptCommands::Topic, 2, 0, 0);
  gh_new_procedure("bot-unlock", (SCMFunc)ScriptCommands::Unlock, 1, 0, 0);

  gh_new_procedure("bot-getnickname", (SCMFunc)ScriptCommands::getNickname, 0, 0, 0);
  gh_new_procedure("bot-getserver", (SCMFunc)ScriptCommands::getServer, 0, 0, 0);
  gh_new_procedure("bot-getserverlist", (SCMFunc)ScriptCommands::getServerList, 0, 0, 0);
  gh_new_procedure("bot-flush", (SCMFunc)ScriptCommands::flushQueue, 0, 0, 0);
  gh_new_procedure("bot-flushport", (SCMFunc)ScriptCommands::flushPort, 0, 0, 0);
  gh_new_procedure("bot-random", (SCMFunc)ScriptCommands::random, 1, 0, 0);
  gh_new_procedure("bot-addcommand", (SCMFunc)ScriptCommands::addCommand, 5, 0, 0);
  gh_new_procedure("bot-delcommand", (SCMFunc)ScriptCommands::delCommand, 1, 0, 0);
  gh_new_procedure("bot-addhook", (SCMFunc)ScriptCommands::AddHook, 3, 0, 0);
  gh_new_procedure("bot-addtimer", (SCMFunc)ScriptCommands::AddTimer, 2, 0, 0);
  gh_new_procedure("bot-deltimer", (SCMFunc)ScriptCommands::DelTimer, 1, 0, 0);
  scm_sysintern("hooks/action", scm_long2num(Hook::ACTION));
  scm_sysintern("hooks/nickname", scm_long2num(Hook::NICKNAME));
  scm_sysintern("hooks/signoff", scm_long2num(Hook::SIGNOFF));
  scm_sysintern("hooks/ctcp", scm_long2num(Hook::CTCP));
  scm_sysintern("hooks/ctcp-reply", scm_long2num(Hook::CTCP_REPLY));
  scm_sysintern("hooks/disconnect", scm_long2num(Hook::DISCONNECT));
  scm_sysintern("hooks/flood", scm_long2num(Hook::FLOOD));
  scm_sysintern("hooks/invite", scm_long2num(Hook::INVITE));
  scm_sysintern("hooks/join", scm_long2num(Hook::JOIN));
  scm_sysintern("hooks/kick", scm_long2num(Hook::KICK));
  scm_sysintern("hooks/leave", scm_long2num(Hook::LEAVE));
  scm_sysintern("hooks/part", scm_long2num(Hook::LEAVE));
  scm_sysintern("hooks/mode", scm_long2num(Hook::MODE));
  scm_sysintern("hooks/message", scm_long2num(Hook::MESSAGE));
  //  scm_sysintern("hooks/names", scm_long2num(Hook::NAMES));
  scm_sysintern("hooks/notice", scm_long2num(Hook::NOTICE));
  scm_sysintern("hooks/public", scm_long2num(Hook::PUBLIC));
  scm_sysintern("hooks/public-notice", scm_long2num(Hook::PUBLIC_NOTICE));
  scm_sysintern("hooks/raw", scm_long2num(Hook::RAW));
  scm_sysintern("hooks/timer", scm_long2num(Hook::TIMER));
  scm_sysintern("hooks/topic", scm_long2num(Hook::TOPIC));
}

void
Interp::Shutdown()
{ }

void
Interp::Execute(Bot *b, String command)
{
#ifdef MULTITHREAD
  // We get the lock
  pthread_mutex_lock(&mutex);
#endif
  bot = b;
  gh_eval_str_with_catch((char *)(const char *)command, ErrorHandler);
#ifdef MULTITHREAD
  // We release the lock
  pthread_mutex_unlock(&mutex);
#endif
}

void
Interp::LoadScript(Bot *b, String filename)
{
#ifdef MULTITHREAD
  // We get the lock
  pthread_mutex_lock(&mutex);
#endif
  bot = b;
  gh_eval_file_with_catch((char *)(const char *)filename, ErrorHandler);
#ifdef MULTITHREAD
  // We release the lock
  pthread_mutex_unlock(&mutex);
#endif
}

SCM
Interp::ErrorHandler(void *data, SCM tag, SCM throw_args)
{
  bot->botInterp->ScriptLog(throw_args);
  return SCM_BOOL_F;
}
