// Utils.C  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <ctype.h>
#include <stdlib.h>

#include "Utils.H"
#include "StringTokenizer.H"

String
Utils::getNick(String nuh)
{
  StringTokenizer st(nuh);
  return st.nextToken('!');
}

String
Utils::getUserhost(String nuh)
{
  StringTokenizer st(nuh);
  st.nextToken('@');
  return st.rest();
}

String
Utils::getKey()
{
  return String((long)rand());
}

bool
Utils::isIP(String host)
{
  for (int i = 0; i < host.length(); i++)
    if (!isdigit(host[i]) && host[i]!='.')
      return false;
  return true;
}

String
Utils::makeWildcard(String mask)
{
  StringTokenizer st(mask);

  st.nextToken('!', true);
  String nick = "*";

  String user = st.nextToken('@', true);
  if (user[0] == '~' || user[0] == '^' ||
      user[0] == '+' || user[0] == '-' ||
      user[0] == '*')
    user = user.subString(1);
  if (user.length() < 10)
    user = String("*") + user;

  String host = st.rest();
  StringTokenizer st2(host);
  if (!isWildcard(host)) {
    if (isIP(host)) {
      host = st2.nextToken('.') + ".";
      host = host + st2.nextToken('.') + ".";
      host = host + st2.nextToken('.') + ".*";
    } else {
      st2.nextToken('.', true);
      if (st2.countTokens('.') > 1)
        host = String("*.") + st2.rest();
    }
  } else {
    if (host == "") host = "*";
  }

  cout << nick + "!" + user + "@" + host << endl;

  return nick + "!" + user + "@" + host;
}

bool
Utils::isChannel(String c)
{
  return (c[0] == '#' || c[0] == '&');
}

bool
Utils::isWildcard(String c)
{
  return (c.find('*') != -1);
}

bool
Utils::isValidChannelName(String c)
{
  return isChannel(c) && c.find(',') == -1;
}

#define isvalid(c) (((c) >= 'A' && (c) <= '~') || isdigit(c) || (c) == '-')

bool
Utils::isValidNickName(String n)
{
  if (n[0] == '-' || isdigit(n[0]) || n.length() > 9)
    return false;

  for (int i = 0; i < n.length(); i++)
    if (!isvalid(n[i]) || isspace(n[i]))
      return false;

  return true;
}

int
Utils::getLevel(Bot * b, String nuh)
{
  return b->userList->getMaxLevel(nuh);
}

int
Utils::getLevel(Bot * b, String nuh, String channel)
{
  if (!isChannel(channel))
    return getLevel(b, nuh);

  if (Channel * c =  b->channelList->getChannel(channel)) {
    User * u = c->getUser(getNick(nuh));
    if (u)
      return u->getLevel();
  } else {
    return -1;
  }

  return b->userList->getLevel(nuh, channel);
}

String
Utils::levelToStr(int l)
{
  switch (l) {
  case User::USER: return "User";
  case User::TRUSTED_USER: return "Trusted User";
  case User::FRIEND: return "Friend";
  case User::MASTER: return "Master";
  }
  return "None";
}

String
Utils::protToStr(int p)
{
  switch (p) {
  case User::NO_BAN: return "No ban";
  case User::NO_KICK: return "No kick";
  case User::NO_DEOP: return "No deop";
  }
  return "None";
}

String
Utils::boolToStr(bool b)
{
  return b ? "True" : "False";
}

time_t
Utils::strToTime(String str)
{
  char num[512];
  int len = 0;
  time_t ans = 0;

  num[0]='\0';

  if (str.toLower() == "Inf")
    return -1;

  if (!isdigit(str[0]))
    return 0;

  for (int i = 0; i < str.length(); i++) {
    switch (str[i]) {
    case 'y':
    case 'Y':
      num[len] = '\0';
      len = 0;
      ans += (atoi(num) * 31557600);
      break;
    case 'M':
      num[len] = '\0';
      len = 0;
      ans += (atoi(num) * 2629800);
      break;
    case 'd':
    case 'D':
      num[len] = '\0';
      len = 0;
      ans += (atoi(num) * 86400);
      break;
    case 'h':
    case 'H':
      num[len] = '\0';
      len = 0;
      ans += (atoi(num) * 3600);
      break;
    case 'm':
      num[len] = '\0';
      len = 0;
      ans += (atoi(num) * 60);
      break;
    case 's':
    case 'S':
      num[len] = '\0';
      len = 0;
      ans += atoi(num);
    default:
      if (isdigit(str[i])) {
        num[len++] = str[i];
        num[len] = '\0';
      } else
        return 0;
    }
  }

  if (len)
    ans += atoi(num);

  return time(0) + ans;
}

#ifdef USESCRIPTS
// Returns a String from an SCM argument
String
Utils::scm2String(SCM s)
{
  char *tmp = gh_scm2newstr(s, 0);
  String temp(tmp);
  free(tmp);
  return temp;
}

// Returns a SCM from an String argument
SCM
Utils::string2SCM(String s)
{
  return gh_str02scm((char *)(const char *)s);
}
#endif
