
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * This is the generic device creator. It will generate the device and give it
 * all the generic handlers and tables. The device init is then also called to
 * provide its specifics.
 */

#include "brightoninternals.h"
#include "brightonDevtable.h"

static int
brightonInitDevice(brightonWindow *bwin, brightonDevice *device, int index,
char *bitmap)
{
	if (device->device == -1)
		return;

	/*
	 * Then call the generic inheritances.
	 */ 
	if ((brightonDevTable[device->device].from >= 0)
		&& (brightonDevTable[device->device].from != index))
	{
		int orgdev = device->device;

		device->device = brightonDevTable[device->device].from;

		brightonInitDevice(bwin, device, index, bitmap);

		device->device = orgdev;
	}

	/*
	 * And finally the specific instances
	 */
	brightonDevTable[device->device].create(bwin, device, index, bitmap);

	return(0);
}

brightonDevice *
brightonCreateDevice(brightonWindow *bwin, int type, int panel,
	int index, char *bitmap)
{
	brightonDevice *device;

//	printf("brightonCreateDevice(%x, %i, %i, %s)\n",
//		bwin, type, index, bitmap);

	if ((type < 0) || (type >= BRIGHTON_DEVTABLE_SIZE))
		return(0);

	device = brightonmalloc(sizeof(brightonDevice));
	device->device = type;
	device->panel = panel;
	device->index = index;
	device->flags |= BRIGHTON_DEV_INITED;

	if (brightonInitDevice(bwin, device, index, bitmap) == 0)
		return(device);
	else {
		brightonDestroyDevice(device);
		return(0);
	}
}

static
brightonDestroyDevices(brightonDevice *device)
{
printf("destroying %x\n", device);
return;
	if ((device == 0) || (device->device == -1))
		return;

	if ((brightonDevTable[device->device].from >= 0)
		&& (brightonDevTable[device->device].from != device->device))
	{
		int index = device->device;

		device->device = brightonDevTable[device->device].from;
		brightonDestroyDevices(device);
		device->device = index;
	}
	brightonDevTable[device->device].destroy(device);
}

int
brightonDestroyDevice(brightonDevice *device)
{
	printf("destroyDevice()\n");

	brightonDestroyDevices(device);

	if (device->destroy)
		device->destroy(device);

	if (device->next)
		device->next->last = device->last;
	if (device->last)
		device->last->next = device->next;

	if (device->shadow.coords)
		brightonfree(device->shadow.coords);
	if (device->shadow.mask)
		brightonfree(device->shadow.mask);

	brightonfree(device);
}

int
brightonConfigureDevice(brightonDevice *dev, brightonEvent *event)
{
}

/*
 * Event can be motion, keypress, varchange, buttonpress, etc.
 * Alterations to world are handled in configure - ie, changes in position,
 * size, etc. We may, however, collapse these into a single call?
 */
int
brightonDeviceEvent(brightonDevice *dev, brightonEvent *event)
{
}

brightonParamChange(void *connid, int panel, int index, brightonEvent *event)
{
	brightonWindow *bwin = (brightonWindow *) connid;

	//printf("brightonParamChange(%x, %i)\n", bwin, index);

	event->command = BRIGHTON_PARAMCHANGE;

/*
	if (type == 0)
		param.args.f = value;
	else if (type == 1)
		param.args.m = (void *) &value;
*/

	if (panel >= bwin->app->nresources)
		return;

	if (bwin->app->resources[panel].devlocn[index].type == -1)
		return;

	/*
	 * See if this is a panel configuration event.
	 */
	if (index == -1)
	{
		if (bwin->app->resources[panel].configure)
			bwin->app->resources[panel].configure
				(bwin, &bwin->app->resources[panel], event);
	} else
		((brightonDevice *) bwin->app->resources[panel].devlocn[index].dev)
			->configure(bwin->app->resources[panel].devlocn[index].dev, event);
}

