#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ncurses.h>
#include "socket.h"
#include "parsecfg.h"
#include "list.h"
#include "screen.h"
#include "utf8.h"

#define JABBERPORT 5222

List roster;
int numbuddies;


char *
gettag (char *buffer, char *what)
{
  char *aux;
  char *aux2;
  char *result = (char *) malloc (1024);
  char *tmp = (char *) malloc (1024);
  memset (result, 0, 1024);
  memset (tmp, 0, 1024);

  sprintf (tmp, "<%s>", what);
  aux = strstr (buffer, tmp);
  if (aux)
    {
      aux += strlen (tmp);
      sprintf (tmp, "</%s>", what);
      aux2 = strstr (aux, tmp);
      if (aux2)
	{
	  strncpy (result, aux, strlen (aux) - strlen (aux2));
	  free (tmp);
	  return result;
	}
    }
  free (tmp);
  free (result);
  return "UNKtag";
}

char *
getattr (char *buffer, char *what)
{
  char *aux;
  char *aux2;
  char *result = (char *) malloc (1024);
  memset (result, 0, 1024);

  aux = strstr (buffer, what);
  if (aux)
    {
      aux += strlen (what);
      aux2 = strstr (aux, "'");
      if (aux2)
	{
	  strncpy (result, aux, strlen (aux) - strlen (aux2));
	  return result;
	}
    }
  free (result);
  return "UNKattr";
}


void
SetPresence (const char *type)
{
  char *str = malloc (1024);

  sprintf (str, "<presence><status>%s</status></presence>", type);
  if (!senddata (str))
    {
      perror ("senddata (server.c:70)");
      exit (EXIT_FAILURE);
    }
  free (str);
}

void
RequestRoster (void)
{
  Ptrnode p;
  elementT x;
  char *response;
  char *aux, *aux2;
  char *str = malloc (1024);

  roster = NewList ();
  p = HeaderList (roster);


  strcpy (str, "<iq type='get' id='1001'><query xmlns='");
  strcat (str, "jabber:iq:roster'/></iq>\n");
  if (!senddata (str))
    {
      perror ("senddata (server.c:33)");
      exit (EXIT_FAILURE);
    }

  response = receivedata ();
  aux = strstr (response, "<item");

  while (1)
    {
      aux2 = strstr (aux, "<item");
      if (!aux2)
	aux2 = strstr (aux, "item");
      if (aux2)
	{
	  char *jid = getattr (aux, "jid='");
	  char *name = getattr (aux, "name='");
	  char *group = gettag (aux, "group='");

	  *aux2 = '\0';

	  x = malloc (sizeof (element));
	  strcpy (x->jid, jid);
	  strcpy (x->name, name);
	  strcpy (x->group, group);
	  x->connected = 0;

	  if (strncmp (jid, "UNK", 3))
	    free (jid);
	  if (strncmp (name, "UNK", 3))
	    free (name);
	  if (strncmp (group, "UNK", 3))
	    free (group);

	  if (!strcmp (x->name, "MSN Service"))
	    {
	      char *l = malloc (1024);
	      sprintf (l, "%c %s %c", 254, x->name, 254);
	      strcpy (x->name, l);
	      free (l);
	    }

	  if ((strncmp (x->jid, "UNK", 3))
	      && (!FindJidInList (x->jid, roster)))
	    {
	      InsertInList (x, p, roster);
	      numbuddies++;
	      p = NextInList (p);
	    }
	  else
	    {
	      free (x);
	    }
#ifdef DEBUG
	  {
	    FILE *fp = fopen ("/tmp/roster.log", "a+");
	    fprintf (fp, "--> %s\n", aux);
	    fclose (fp);
	  }
#endif
	  aux = aux2;
	  aux++;
	}
      else
	break;
    }
  free (str);
  free (response);
  SortListByName (roster);
}

int
ConnectToServer (void)
{
  char *servername = CFGRead ("server");

  if (!servername)
    {
      fprintf (stderr, "You must supply a server in $HOME/.cabberrc");
      exit (EXIT_FAILURE);
    }
  if (!connectJabber (servername, JABBERPORT))
    {
      fprintf (stderr, "Cant connect to \"%s\"", servername);
      exit (EXIT_FAILURE);
    }
  return 1;
}

char *
LogInServer (void)
{
  char *stringtosend = malloc (2048);
  char *response, *aux;
  char *idsession = malloc (128);
  int pos = 0;

  memset (stringtosend, 0, 2048);
  strcpy (stringtosend, "<?xml version='1.0' encoding='UTF-8' ?>");
  strcat (stringtosend, "<stream:stream to='");
  strcat (stringtosend, CFGRead ("server"));
  strcat (stringtosend, "' xmlns='jabber:client' xmlns:stream='");
  strcat (stringtosend, "http://etherx.jabber.org/streams'>\n");

  if (!senddata (stringtosend))
    {
      perror ("senddata (server.c:41)");
      exit (EXIT_FAILURE);
    }
  response = receivedata ();
  if (strstr (response, "error"))
    {
      fprintf (stderr, "Response not valid:\n%s\n\n", response);
      exit (EXIT_FAILURE);
    }
  aux = response;
  while (strncmp (aux, "id", 2))
    aux++;
  pos = 0;
  aux += 4;
  while (strncmp (aux, "'", 1))
    {
      aux++;
      pos++;
    }
  aux -= pos;
  strncpy (idsession, aux, pos);

  free (response);

  strcpy (stringtosend, "<iq type='set' id='1000'>");
  strcat (stringtosend, "<query xmlns='jabber:iq:auth'>");
  strcat (stringtosend, "<username>");
  strcat (stringtosend, CFGRead ("username"));
  strcat (stringtosend, "</username><password>");
  strcat (stringtosend, CFGRead ("password"));
  strcat (stringtosend, "</password><resource>");
  strcat (stringtosend, CFGRead ("resource"));
  strcat (stringtosend, "</resource></query></iq>\n");
  if (!senddata (stringtosend))
    {
      perror ("senddata (server.c:69)");
      exit (EXIT_FAILURE);
    }
  response = receivedata ();
  if (strstr (response, "error"))
    {
      fprintf (stderr, "Response not valid:\n%s\n\n", response);
      exit (EXIT_FAILURE);
    }
  free (response);
  free (stringtosend);

  return idsession;
}

void
ChangeStatus (char *from, int status, int offset, int selected)
{
  char *aux;
  Ptrnode p;
  elementT x;
  int found = 0;

  aux = strchr (from, '/');
  if (aux)
    *aux = '\0';

  p = HeaderList (roster);
  while ((p) && (!found))
    {
      x = RetrieveFromList (p);
      p = NextInList (p);
      if (!strncmp (from, x->jid, strlen (from)))
	{
	  x->connected = status;
	  found = 1;
	}
    }
  DrawRoster (roster, offset, selected);
  refresh ();
}

void
checkdatafromserver (char *buffer, int offset, int selected)
{
  int msgtype = 0;
  char *to = getattr (buffer, "to='");
  char *from = getattr (buffer, "from='");
  char *id = getattr (buffer, "id='");
  char *type = getattr (buffer, "type='");
  char *body = gettag (buffer, "body");
  char *status = gettag (buffer, "status");
  char *show = gettag (buffer, "show");
  char *line = (char *) malloc (1024);
  char *tmp, *tmp2;

  memset (line, 0, 1024);

  // scan for buffer
  if (!strncmp (buffer, "<message", 8))	// manage messages
    {
      msgtype = 1;
    }
  else if (!strncmp (buffer, "<presence", 9))	// manage presences
    {
      if (!strncmp (type, "UNK", 3))	// asume online
	{
	  char *aux;
	  Ptrnode p;
	  elementT x;
	  int found = 0;

	  msgtype = 2;

	  aux = strchr (from, '/');
	  if (aux)
	    {
	      *aux = '\0';
	      aux++;
	      // actualize presence

	      p = FirstInList (roster);
	      while ((p) && (!found))
		{
		  x = RetrieveFromList (p);
		  p = NextInList (p);
		  if (!strcmp (x->jid, from))
		    {
		      strcpy (x->resource, aux);
		      found = 1;
		    }
		}
	    }
	  ChangeStatus (from, 1, offset, selected);
	}
      else if (!strncmp (type, "unavailable", 11))	// offline
	{
	  msgtype = 3;
	  ChangeStatus (from, 0, offset, selected);
	}
      else
	{
	  // display unhandled msg
	  msgtype = 255;
	}
    }

  // write the parsed buffer
  switch (msgtype)
    {
    case 1:
      tmp = FindJidNameInList (from, roster);
      tmp2 = fromUTF8 (body);
      sprintf (line, "<%s> %s", tmp, tmp2);
      PrintWrapMessage (line);
      free (tmp2);
      break;

    case 2:
      tmp = FindJidNameInList (from, roster);
      sprintf (line, ">>> %s", tmp);
      PrintWrapMessage (line);
      break;

    case 3:
      tmp = FindJidNameInList (from, roster);
      sprintf (line, "<<< %s", tmp);
      PrintWrapMessage (line);
      break;
    case 255:
      {
	FILE *fp = fopen ("/tmp/cabberlog", "a+");
	sprintf (line, "--> Unhandled response <--");
	fprintf (fp, "%s\n", line);
	fclose (fp);
	PrintWrapMessage (line);
      }
      break;
    }
  free (line);
  if (strncmp (to, "UNK", 3))
    free (to);
  if (strncmp (from, "UNK", 3))
    free (from);
  if (strncmp (id, "UNK", 3))
    free (id);
  if (strncmp (type, "UNK", 3))
    free (type);
  if (strncmp (body, "UNK", 3))
    free (body);
  if (strncmp (status, "UNK", 3))
    free (status);
  if (strncmp (show, "UNK", 3))
    free (show);
}

void
SendInputLine (char *inputline, int offset, int selected)
{
  char *tmp = malloc (1024);
  char *stringtosend = malloc (2048);
  char *username = CFGRead ("username");
  char *server = CFGRead ("server");
  char *resource = CFGRead ("resource");
  char *jid = FindSelectedJidJidInList (selected, roster);
  char *utf8inputline = toUTF8 (inputline);

  snprintf (tmp, 1024, "<%s> %s", username, inputline);
  PrintWrapMessage (tmp);

  sprintf (stringtosend,
	   "<message from='%s@%s/%s' to='%s' type='chat'><body>%s</body></message>",
	   username, server, resource, jid, utf8inputline);
  if (!senddata (stringtosend))
    {
      perror ("send");
      exit (1);
    }
  free (tmp);
  free (stringtosend);
  free (utf8inputline);
}
