(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Parse and values of arguments. *)

(** The list of root directories to use. *)
let roots = ref []

(** Whether the repository is available or not. *)
let with_rep = ref true

(** Initial commands to execute. *)
let init_commands = ref ([] : string list)

(** The list of options.*)
let options_list = [
  "-v", Arg.Unit (fun () -> print_string Cam_messages.software_version ; print_newline () ; exit 0), Cam_messages.opt_version ;
  "-norep", Arg.Clear with_rep, Cam_messages.opt_no_rep ;
  "-com", Arg.String (fun s -> init_commands := !init_commands @ [s]), Cam_messages.opt_init_commands ;
] @ (Options.simple_args Cam_config.gui_ini)
  

(** Parse of the command line arguments. *)
let parse () = 
  Arg.parse options_list 
    (fun s -> 
      (* remove ending slash before, or else
	 it causes trouble in class data to say
	 that two elements are the same. *)
      let len = String.length s in
      match len with
	0 -> ()
      | _ ->
	  let dir =
	    if s.[len - 1] = '/' then
	      String.sub s 0 (len -1)
	    else
	      s
	  in
	  try
	    let st = Unix.stat dir in
	    if st.Unix.st_kind = Unix.S_DIR then
	      roots := !roots @ [dir]
	    else
	      prerr_endline (dir^" is not a directory")
	  with
	    Unix.Unix_error (e, s1, s2) ->
	      prerr_endline ((Unix.error_message e)^": "^s2)
    )
    Cam_messages.usage;

  if !roots = [] then 
    roots := [Filename.current_dir_name]
  else
    ()

