/* Site-specific code. Here parsing and more of this site is.
 * $Id: Filewatcher.pike,v 1.4 2001/01/28 08:45:12 neotron Exp $
 *
 * Written by David Hedbor <david@hedbor.org>.
 *
 */

import Headlines;

#include <headlines/base.h>

constant name = "filewatcher";
constant site = "File Watcher";
constant url  = "http://filewatcher.org/";
constant path = "backend/1.0/";
constant names =  ({ "title", "link", "time","author","empty1","empty2","empty3","type","empty" });
constant titles =  ({ "title", "link", "time","author","empty1","empty2","empty3","type","empty" });
constant full_names =  ({ "title", "link", "time","author","empty1","empty2","empty3","type","empty" });
constant sub = "Applications/Filewatcher";

array headlines;

private static void fetch_failed(object http)
{
  werror("%s: failed to get headlines..\n", site);
}

private static void parse_reply(string data)
{
  foreach((data / "%%"), string s)
  {
    //if (search(s,".html") != -1)
    //  s = url + s;
    array lines = s / "\n" - ({""});
    if(sizeof(lines) == 9) {
      if(strlen(lines[1]) > 52)
	lines[1] = lines[1][..48]+" /...";
      headlines += ({ mkmapping(full_names, lines) });
    }
  }
}

string entry2txt(mapping hl)
{
  return sprintf("Title:     %s\n"
		 "URL:       %s\n"
		 "Posted by: %s\n"
		 "Date:      %s\n",
		 hl->title||"None", 
		 HTTPFetcher()->encode(hl->url||""),
		 hl->author,hl->date
		 );
}
