*
* $Id: nn2bod.F,v 1.1.1.1 1995/10/24 10:21:58 cernlib Exp $
*
* $Log: nn2bod.F,v $
* Revision 1.1.1.1  1995/10/24 10:21:58  cernlib
* Geant
*
*
#include "geant321/pilot.h"
*CMZ :  3.21/02 29/03/94  15.41.48  by  S.Giani
*-- Author :
      SUBROUTINE NN2BOD(D,LD,KZ1,KZ2,A1,A2,Z1,Z2,ATAR,Q,MT)
C       THIS ROUTINE CALCULATES THE EXIT ENERGIES AND DIRECTIONAL
C       COSINES FOR THE CHARGED PARTICLE AND RECOIL NUCLEUS FOR
C       A TWO-BODY REACTION USING AN EVAPORATION SPECTRUM AND
C       MOMEMTUM BALANCE.  IT ALSO SETS ALL EXIT PARAMETERS FOR
C       THE COLLISION PRODUCTS AND STORES THEM IN THE RECOIL BANK.
C       THE TWO BODY REACTION RESULTS FROM THE BREAK-UP OF A NUCLEUS
C       LEFT IN AN EXCITED STATE BY AN INELASTIC COLLISION OR A
C       N,2N REACTION (I.E. MT-24).
#include "geant321/minput.inc"
#include "geant321/mconst.inc"
#include "geant321/mrecoi.inc"
#include "geant321/mapoll.inc"
#include "geant321/mmass.inc"
#include "geant321/mpstor.inc"
#include "geant321/mnutrn.inc"
      DIMENSION D(*),LD(*)
      SAVE
C       TRANSFER THE RECOILING COMPOUND NUCLEUS PARAMETERS OUT OF
C       COMMON RECOIL FOR USE IN THE MOMENTUM BALANCE EQUATIONS
      ERCN=ER
      URCN=UR
      VRCN=VR
      WRCN=WR
      ARCN=AR
      NZRCN=NZR
      ZARCN=ARCN*9.31075E+08
C       CALCULATE THE COULOMB BARRIER (CB)
      CALL BARIER(KZ1,KZ2,A1,A2,CB)
C       CALCULATE THE CHARGED PARTICLE EXIT ENERGY (EX)
      CALL CEVAP1(EOLD,E,Q,ATAR,CB,EX)
      E1=EX+CB
C       ASSUME ISOTROPIC CHARGED PARTICLE EMISSION IN THE LABORATORY
      CALL GTISO(U1,V1,W1)
C       CALCULATE AND SET THE CHARGED PARTICLE EXIT PARAMETERS
      XR=X
      YR=Y
      ZR=Z
      WATER=WTBC
      NZR=KZ1
      AGER=AGE
      NCOLR=NCOL
      MTNR=MT
      AR=A1
      ENIR=EOLD
      UNIR=UOLD
      VNIR=VOLD
      WNIR=WOLD
      ENOR=E
      UNOR=U
      VNOR=V
      WNOR=W
      WTNR=WATE
      QR=Q
      UR=U1
      VR=V1
      WR=W1
      ER=E1
C       STORE THE CHARGED PARTICLE IN THE RECOIL BANK
      EP = ER
      UP = UR
      VP = VR
      WP = WR
      AGEP = AGE
      MTP = MT
      AMP = AR
      ZMP = FLOAT(NZR)
      CALL STOPAR(IDHEVY,NHEVY)
C       CALCULATE THE TOTAL MOMENTUM BEFORE THE COLLISION
C       COMPOUND NUCLEUS MOMENTUM BEFORE THE COLLISION (PI) EQUALS
C       THE TOTAL MOMENTUM
      PI=SQRT(2.0*ZARCN*ERCN)
C       CALCULATE THE TOTAL MOMEMTUM OF THE EXIT CHARGED PARTICLE
      PO=SQRT(2.0*Z1*E1)
C       CALCULATE THE DIRECTIONAL MOMENTUM OF THE RECOIL NUCLEUS
      PRX=PI*URCN-PO*U1
      PRY=PI*VRCN-PO*V1
      PRZ=PI*WRCN-PO*W1
C       CALCULATE THE TOTAL MOMENTUM OF THE RECOIL NUCLEUS
      PR=SQRT(PRX**2+PRY**2+PRZ**2)
C       CALCULATE THE RECOIL NUCLEUS DIRECTIONAL COSINES
      U2=PRX/PR
      V2=PRY/PR
      W2=PRZ/PR
C       CALCULATE THE RECOIL NUCLEUS EXIT ENERGY
      XM = A2 * 931.075E6
      E2 = SQRT(PR**2 + XM**2) - XM
C       CALCULATE AND SET THE CHARGED PARTICLE EXIT PARAMETERS
      XR=X
      YR=Y
      ZR=Z
      WATER=WTBC
      NZR=KZ2
      AGER=AGE
      NCOLR=NCOL
      MTNR=MT
      AR=A2
      ENIR=EOLD
      UNIR=UOLD
      VNIR=VOLD
      WNIR=WOLD
      ENOR=E
      UNOR=U
      VNOR=V
      WNOR=W
      WTNR=WATE
      QR=Q
      UR=U2
      VR=V2
      WR=W2
      ER=E2
C       STORE THE RECOIL HEAVY ION IN THE RECOIL BANK
      EP = ER
      UP = UR
      VP = VR
      WP = WR
      AGEP = AGE
      MTP = MT
      AMP = AR
      ZMP = FLOAT(NZR)
      CALL STOPAR(IDHEVY,NHEVY)
      RETURN
      END
