/*
 * Cheops Network User Interface
 *
 * Copyright (C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU GPL
 *
 */

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <pwd.h>
#include "cheops.h"

struct port_scan {
	struct net_object *no;
	GtkWidget *window;
	GtkWidget *clist;
	GtkWidget *vbox;
};

void probe_setcursor(int c, GtkWidget *window)
{
	generic_setcursor(window->window, c);
}

void portscan_callback(void *data, int porti)
{
	char buf[256];
	char *port, *desc=NULL;
	struct port_scan *ps = (struct port_scan *)data;
	char *stuff[3];
	int pos=-1;
	int res;
	char *oldp;
	FILE *f;
	f=fopen("/etc/services", "r");
	port="";
	buf[0]='\0';
	while(!feof(f)) {
		fgets(buf, sizeof(buf), f);
		buf[strlen(buf)-1]='\0';
		port = buf;
		while(*port && (*port > 32)) port++;
		if (!*port) continue;
		*port='\0';
		port++;
		while(*port && (*port < 33)) port++;
		if (!*port) continue;
		desc = port;
		while(*desc && (*desc != '/')) desc++;
		if (!*desc) continue;
		*desc='\0';
		desc++;
		while(*desc && (*desc > 32)) desc++;
		if (*desc) 
			while(*desc && (*desc < 33)) desc++;
		if (!*desc)
			desc="";
		if (atoi(port) == porti)
			break;
	}
	fclose(f);
	if (atoi(port) != porti) {
		desc="";
		buf[0]='\0';
		port = &buf[1];
		g_snprintf(port, sizeof(buf), "%d", porti);
	}
	stuff[0]=port;
	stuff[1]=buf;
	stuff[2]=desc;
	do {
		pos++;
		res = gtk_clist_get_text(GTK_CLIST(ps->clist), pos, 0, &oldp);
	} while (res && (atoi(oldp) < porti));
	gtk_clist_insert(GTK_CLIST(ps->clist), pos, stuff);
	
}

int close_scan(GtkWidget *w)
{
	struct port_scan *ps;
	ps = (struct port_scan *)gtk_object_get_user_data(GTK_OBJECT(w));
	if (ps) {
		gtk_widget_destroy(ps->window);
		g_free(ps);
	}
	return FALSE;
}

void more_callback(GtkWidget *w, struct port_scan *ps)
{
	GtkWidget *clist;
	static char *titles[] = { "Port", "Server", "Version" };
	char *c, *d;
	char *args[3];
	int found=0;
	int x;
#if (GTK_MINOR_VERSION > 1) || ((GTK_MINOR_VERSION > 0) && (GTK_MICRO_VERSION > 4))
	GtkWidget *sw;
#endif	

	
	clist = gtk_clist_new_with_titles(3, titles);
#if ((GTK_MINOR_VERSION > 0) && (GTK_MICRO_VERSION > 2))  || (GTK_MAJOR_VERSION > 1)
	gtk_clist_set_column_auto_resize(GTK_CLIST(clist), 0, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(clist), 1, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(clist), 2, TRUE);
#else
	gtk_clist_set_column_width(GTK_CLIST(clist), 0,40);
	gtk_clist_set_column_width(GTK_CLIST(clist), 1,80);
#endif	

#if (GTK_MINOR_VERSION > 1) || ((GTK_MINOR_VERSION > 0) && (GTK_MICRO_VERSION > 4))
	sw = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(sw);
	gtk_container_add(GTK_CONTAINER(sw), clist);
	gtk_box_pack_start(GTK_BOX(ps->vbox), sw, TRUE, TRUE, 5);
#else
	gtk_box_pack_start(GTK_BOX(ps->vbox), clist, TRUE, TRUE, 5);
#endif	

	gtk_widget_set_sensitive(w, FALSE);

	x=0;
	probe_setcursor(GDK_WATCH, ps->window);
	while(gtk_clist_get_text(GTK_CLIST(ps->clist), x, 0, &c)) {
		if ((d = get_version(ps->no->ip_addr, atoi(c)))) {
			found++;
			args[0]=c;
			args[1]=get_name(atoi(c));
			args[2]=d;
			gtk_clist_append(GTK_CLIST(clist), args);
		}
		x++;
	}
	gdk_window_set_cursor(ps->window->window, NULL);
	if (!found) {
		args[0]="None";
		args[1]="";
		args[2]="";
		gtk_clist_append(GTK_CLIST(clist), args);
	}
	gtk_widget_show(clist);
}

void port_scanner(struct net_object *no)
{
	struct in_addr me;
	struct port_scan *ps;
	GtkWidget *hbox;
	GtkWidget *ok;
	GtkWidget *more;
	GtkWidget *label;
	char buf[256];
	static char *titles[] = { "Port", "Service", "Description", NULL };
#if (GTK_MINOR_VERSION > 1) || ((GTK_MINOR_VERSION > 0) && (GTK_MICRO_VERSION > 4))
	GtkWidget *sw;
#endif	
	ps = g_new0(struct port_scan, 1);
	ps->no = no;
	ps->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	ps->clist = gtk_clist_new_with_titles(3, titles);
	ps->vbox = gtk_vbox_new(FALSE, 5);
	hbox = gtk_hbox_new(FALSE, 20);
	g_snprintf(buf, sizeof(buf), "TCP Portscan of %s", no->hostname);
	label = gtk_label_new(buf);
	gtk_widget_show(label);
	ok = gtk_button_new_with_label("  Close  ");
	more = gtk_button_new_with_label("  More  ");
	gtk_widget_realize(ps->window);
	fix_icon(ps->window->window);
	gtk_window_set_title(GTK_WINDOW(ps->window), buf);

	gtk_box_pack_start(GTK_BOX(ps->vbox), label, FALSE, FALSE, 10);

#if ((GTK_MINOR_VERSION > 0) && (GTK_MICRO_VERSION > 2))  || (GTK_MAJOR_VERSION > 1)
	gtk_clist_set_column_auto_resize(GTK_CLIST(ps->clist), 0, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(ps->clist), 1, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(ps->clist), 2, TRUE);
#else
	gtk_clist_set_column_width(GTK_CLIST(ps->clist), 0,40);
	gtk_clist_set_column_width(GTK_CLIST(ps->clist), 1,80);
#endif	

#if (GTK_MINOR_VERSION > 1) || ((GTK_MINOR_VERSION > 0) && (GTK_MICRO_VERSION > 4))
	sw = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(sw);
	gtk_container_add(GTK_CONTAINER(sw), ps->clist);
	gtk_box_pack_start(GTK_BOX(ps->vbox), sw, TRUE, TRUE, 5);
#else
	gtk_box_pack_start(GTK_BOX(ps->vbox), ps->clist, TRUE, TRUE, 5);
#endif	
	gtk_widget_show(ps->clist);
	gtk_widget_show(ps->vbox);
	gtk_widget_show(hbox);
	gtk_widget_show(ok);
	gtk_widget_show(more);
	gtk_object_set_user_data(GTK_OBJECT(ok), ps);
	gtk_object_set_user_data(GTK_OBJECT(more), ps);
	gtk_object_set_user_data(GTK_OBJECT(ps->window), ps);
	gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(close_scan), ps);
	gtk_signal_connect(GTK_OBJECT(more), "clicked", GTK_SIGNAL_FUNC(more_callback), ps);
	gtk_signal_connect(GTK_OBJECT(ps->window), "delete_event", GTK_SIGNAL_FUNC(close_scan), ps);
	gtk_box_pack_start(GTK_BOX(hbox), ok, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(hbox), more, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(ps->vbox), hbox, FALSE, FALSE, 5);
	gtk_container_add(GTK_CONTAINER(ps->window), ps->vbox);
	me = getlocalip(no->ip_addr);
	g_snprintf(buf, sizeof(buf), "Scanning %s...", no->hostname);
	set_status(buf);
	immediate_setcursor(GDK_WATCH);
	full_scan(portscan_callback, me.s_addr, no->ip_addr, 10, ps);
	gdk_window_set_cursor(main_window.window->window, NULL);
	set_status("Scanning complete");
	gtk_widget_set_usize(ps->window, 400, 400);
	gtk_widget_grab_focus(ok);
	gtk_widget_show(ps->window);
}
