/*
 * iolib.h
 *
 * crafted - a pud editor for the freecraft project.
 * 
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 * $Id: iolib.h,v 1.4 2002/01/04 22:46:45 dindinx Exp $
 */

#ifndef __IOLIB_H__
#define __IOLIB_H__

#include "config.h"

/* FIXME: Add archive-style file support here (.DAT, .WAD, .AR, etc) */

#ifdef HAVE_ZLIB
#include <zlib.h>
#endif

#ifdef USE_BZ2LIB
#include <bzlib.h>
#endif

/*----------------------------------------------------------------------------
--	Definitons
----------------------------------------------------------------------------*/

/**
**	FileList struct used by directory access routine
*/
typedef struct _filelist_
{
  char *name;
  int type;
  void *xdata;
} FileList;


#if !defined(HAVE_ZLIB) && !defined(USE_BZ2LIB) 

/* use plain file routines directly */

#define CLFile				FILE
#define CLopen(file)			fopen(file,"rb")
#define CLread(file,buf,len)		fread(buf,1,len,file)
#define CLseek(file,offset,whence)	fseek(file,offset,whence)
#define CLclose(file)			fclose(file)

#else	// !USE_ZLIB && !USE_BZ2LIB

/**
**	Defines a library file
*/
typedef struct _CL_File_
{
  int	  cl_type;		/// type of CLFile
  FILE	*cl_plain;		/// standard file pointer
#ifdef HAVE_ZLIB
  gzFile *cl_gz;			/// gzip file pointer
#endif	// !USE_ZLIB
#ifdef USE_BZ2LIB
  BZFILE *cl_bz;			/// bzip2 file pointer
#endif	// !USE_BZ2LIB
} CLFile;

#define CLF_TYPE_INVALID	0
#define CLF_TYPE_PLAIN		1
#define CLF_TYPE_GZIP		2
#define CLF_TYPE_BZIP2		3

/*----------------------------------------------------------------------------
--	Functions
----------------------------------------------------------------------------*/

extern CLFile *CLopen(const char *fn);			  ///  Library file open
extern int CLclose(CLFile *file);			  ///  Library file close
extern int CLread(CLFile *file, void *buf, size_t len);	  ///  Library file read
extern int CLseek(CLFile *file, long offset, int whence); ///  Library file seek


#endif	// HAVE_ZLIB || USE_BZ2LIB

    /// Build libary path name
extern char* LibraryFileName(const char* file,char* buffer);

    /// Read the contents of a directory
extern int ReadDataDirectory(const char* dirname,int (*filter)(char *,FileList *),FileList **flp);

#endif	// !__IOLIB_H__
