/*
          Copyright (C) 1993, 1994, RSNA and Washington University

          The software and supporting documentation for the Radiological
          Society of North America (RSNA) 1993, 1994 Digital Imaging and
          Communications in Medicine (DICOM) Demonstration were developed
          at the
                  Electronic Radiology Laboratory
                  Mallinckrodt Institute of Radiology
                  Washington University School of Medicine
                  510 S. Kingshighway Blvd.
                  St. Louis, MO 63110
          as part of the 1993, 1994 DICOM Central Test Node project for, and
          under contract with, the Radiological Society of North America.

          THIS SOFTWARE IS MADE AVAILABLE, AS IS, AND NEITHER RSNA NOR
          WASHINGTON UNIVERSITY MAKE ANY WARRANTY ABOUT THE SOFTWARE, ITS
          PERFORMANCE, ITS MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR
          USE, FREEDOM FROM ANY COMPUTER DISEASES OR ITS CONFORMITY TO ANY
          SPECIFICATION. THE ENTIRE RISK AS TO QUALITY AND PERFORMANCE OF
          THE SOFTWARE IS WITH THE USER.

          Copyright of the software and supporting documentation is
          jointly owned by RSNA and Washington University, and free access
          is hereby granted as a license to use this software, copy this
          software and prepare derivative works based upon this software.
          However, any distribution of this software source code or
          supporting documentation or derivative works (source code and
          supporting documentation) must include the three paragraphs of
          the copyright notice.
*/
/* Copyright marker.  Copyright will be inserted above.  Do not remove */

/*
**		     Electronic Radiology Laboratory
**		   Mallinckrodt Institute of Radiology
**		Washington University School of Medicine
**
** Module Name(s):	formatPatient
**			formatStudy
**			formatSeries
**			formatImage
**			formatInstance
** Author, Date:	Steve Moore, Summer 1994
** Intent:		This set of functions is used to format IDB structures
**			for inclusion ASCII lists.  These functions are called
**			for each item to be displayed in a list; each function
**			is expected to generate a line of text that describes/
**			identifies the item.
** Last Update:		$Author: smm $, $Date: 1995/12/19 15:22:35 $
** Source File:		$RCSfile: format.c,v $
** Revision:		$Revision: 1.5 $
** Status:		$State: Exp $
*/

static char rcsid[] = "$Revision: 1.5 $ $RCSfile: format.c,v $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dicom.h"
#include "condition.h"
#include "lst.h"
#include "dicom_objects.h"
#include "tbl.h"
#include "idb.h"

#include "idb_viewer.h"
#include "format.h"

/* formatPatient
**
** Purpose:
**	formatPatient is used to format one patient-level record returned
**	from the IDB.  It formats a NULL record to allow the user interface
**	to go back up one level (this is poor implementation).  The real
**	format includes the patient ID, name and birthdate.
**
** Parameter Dictionary:
**	item		Pointer to the structure containing the patient-level
**			record
**	index		The number of the record in the list (0...N-1)
**	buf		Output area for text generated by this function.
**
** Return Values:
**	None
*/

void
formatPatient(QUERY_LIST_ITEM * item, int index, char *buf)
{
    if (index == 0)
	strcpy(buf, "... Up 1 level ...");
    else
	sprintf(buf, "%-16s %-30s %-12s",
		item->query.patient.PatID,
		item->query.patient.PatNam,
		item->query.patient.PatBirDat);
}

/* formatStudy
**
** Purpose:
**	formatStudy is used to format one study-level record returned
**	from the IDB.  It formats a NULL record to allow the user interface
**	to go back up one level (this is poor implementation).  The real
**	format includes the accession number, study ID, and study instance
**	UID.
**
** Parameter Dictionary:
**	item		Pointer to the structure containing the study-level
**			record
**	index		The number of the record in the list (0...N-1)
**	buf		Output area for text generated by this function.
**
** Return Values:
**	None
*/

void
formatStudy(QUERY_LIST_ITEM * item, int index, char *buf)
{
    char
        accession[20] = "",
        studyID[20] = "";

    if (index == 0)
	strcpy(buf, "... Up 1 level ...");
    else {
	if (!(item->query.StudyNullFlag & QF_STU_AccNum))
	    strcpy(accession, item->query.study.AccNum);
	if (!(item->query.StudyNullFlag & QF_STU_StuID))
	    strcpy(studyID, item->query.study.StuID);

	(void) sprintf(buf, "%-64s %-16s %-16s",
		       item->query.study.StuInsUID,
		       accession,
		       studyID);
    }
}

/* formatSeries
**
** Purpose:
**	formatSeries is used to format one series-level record returned
**	from the IDB.  It formats a NULL record to allow the user interface
**	to go back up one level (this is poor implementation).  The real
**	format includes the series instance UID.
**
** Parameter Dictionary:
**	item		Pointer to the structure containing the series-level
**			record
**	index		The number of the record in the list (0...N-1)
**	buf		Output area for text generated by this function.
**
** Return Values:
**	None
*/

void
formatSeries(QUERY_LIST_ITEM * item, int index, char *buf)
{
    if (index == 0)
	strcpy(buf, "... Up 1 level ...");
    else
	(void) sprintf(buf, "%-64s",
		       item->query.series.SerInsUID);
}

/* formatImage
**
** Purpose:
**	formatImage is used to format one image-level record returned
**	from the IDB.  It formats a NULL record to allow the user interface
**	to go back up one level (this is poor implementation).  The real
**	format includes the (image) SOP instance UID.
**
** Parameter Dictionary:
**	item		Pointer to the structure containing the image-level
**			record
**	index		The number of the record in the list (0...N-1)
**	buf		Output area for text generated by this function.
**
** Return Values:
**	None
*/

void
formatImage(QUERY_LIST_ITEM * item, int index, char *buf)
{
    if (index == 0)
	strcpy(buf, "... Up 1 level ...");
    else
	(void) sprintf(buf, "%-64s",
		       item->query.image.SOPInsUID);
}

/* formatInstance
**
** Purpose:
**	formatInstance is used to format one instance-level record returned
**	from the IDB.  It formats a NULL record to allow the user interface
**	to go back up one level (this is poor implementation).  The real
**	format includes the path name to the instance.
**
** Parameter Dictionary:
**	item		Pointer to the structure containing the instance-level
**			record
**	index		The number of the record in the list (0...N-1)
**	buf		Output area for text generated by this function.
**
** Return Values:
**	None
*/

void
formatInstance(IDB_InstanceListElement * item, int index, char *buf)
{
    if (index == 0)
	strcpy(buf, "... Up 1 level ...");
    else
	(void) sprintf(buf, "%-80s",
		       item->Path);
}
