#! /usr/local/bin/python -O
"""Wait while bytes-total, reported by darkstat,
will be increased by the given amount.

Example: dstat-wait.py localhost 8080 5M
   wait until 5 megbytes passed through

This file is a part of darkstat (http://purl.org/net/darkstat)
Author: Oleg Broytmann <phd@phd.pp.ru>
License: GPL
"""


import sys
from darkstat.info_txt import DarkstatAPI


def usage():
   sys.exit("Usage: %s [-v] host port amount [pause]" % sys.argv[0])


verbose = 0
pause = 10 # seconds

from getopt import getopt, GetoptError

try:
   options, arguments = getopt(sys.argv[1:], 'hv', ['help'])
except GetoptError:
   usage()

for option, value in options:
   if option == '-v':
      verbose += 1
   elif option == '-h':
      usage()
   elif option == '--help':
      usage()

if len(arguments) in (3, 4):
   host = arguments[0]
   port = int(arguments[1])
   amount = arguments[2]

   if len(arguments) == 4:
      pause = arguments[3]

else:
   usage()


if verbose >= 1: print "Trying darkstat at %s:%s" % (host, port)
darkstat = DarkstatAPI(host, port)


units = {
   'b' : 1,
   'c' : 1,
   'k' : 1024,
   'm' : 1024*1024,
   'g' : 1024*1024*1024,
   't' : 1024*1024*1024*1024
}

if amount[-1].lower() in units:
   unit = amount[-1].lower()
   amount = long(amount[:-1])*units[unit]

else:
   amount = long(amount)


from time import sleep

bytes_total = darkstat.get_total_bytes()
if verbose >= 1:
   print "   start at byte %d" % bytes_total
   print "  amount (bytes) %d" % amount
   print "    waiting byte %d (press ^C to interrupt)" % (bytes_total + amount)

while 1:
   sleep(pause)
   current = darkstat.get_total_bytes()
   if current - bytes_total >= amount:
      break
   else:
      if verbose >= 2: print "    current byte %d" % current
if verbose >= 1: print "    current byte %d" % current
