
/* darkstat: a network traffic analyzer
 * (c) 2001-2003, Emil Mikulic.
 */

#ifndef __BIGNUM_H
#define __BIGNUM_H

#include "darkstat.h"



#ifndef HAVE_64MATH

typedef struct { dword hi, lo; } int64;

#define SET64(x,h,l) { x.hi = h; x.lo = l; }
#define HI(x) (x.hi)
#define LO(x) (x.lo)

#define i64add64(dest,src) { /* int64 dest, int64 src */ \
	dest.hi += src.hi; \
	if (dest.lo + src.lo < dest.lo) dest.hi++; /* carry */ \
	dest.lo += src.lo; \
	}

#define i64add32(dest,src) { /* int64 dest, dword src */ \
	if (dest.lo + src < dest.lo) dest.hi++; /* carry */ \
	dest.lo += src; \
	}

#define db_i64div32(num, denom) ( /* int64 num, dword denom */ \
	( (double)(num.hi) * 4294967295.0 + (double)(num.lo) ) \
	/ (double)(denom) )

#define i_i64divdb(num, denom) ( /* int64 num, double denom */ \
	(int)db_i64div32(num,denom) )

/* is a smaller than b? */
#define i64smaller(a,b) ( \
	(a.hi < b.hi) ? 1 : \
	(a.hi > b.hi) ? 0 : \
	(a.lo < b.lo) ? 1 : 0 )

/* is a bigger than b? */
#define i64bigger(a,b) ( \
	(a.hi > b.hi) ? 1 : \
	(a.hi < b.hi) ? 0 : \
	(a.lo > b.lo) ? 1 : 0 )

#define i64max(a,b) (i64bigger(a,b)?a:b)
#define i64min(a,b) (i64smaller(a,b)?a:b)

#define fwrite64(i, fp) { fwrite(&(i.hi), sizeof(dword), 1, fp); \
			  fwrite(&(i.lo), sizeof(dword), 1, fp); }

#define fread64(i, fp, numread) { \
	numread = fread(&(i.hi), sizeof(dword), 1, fp); \
	numread += fread(&(i.lo), sizeof(dword), 1, fp); \
	if (numread == 2) numread = 1; else numread = 0; }



#else /* HAVE_64MATH */



typedef long long int int64;
#define HI(x) ((dword) (((x) >> 32) & 0xFFFFFFFF))
#define LO(x) ((dword) ((x) & 0xFFFFFFFF))
#define SET64(x,h,l) x = ( ( ((int64)(h)) & 0xFFFFFFFF ) << 32 ) |\
			 (   ((int64)(l)) & 0xFFFFFFFF )

#define i64smaller(a,b) ((a) < (b))
#define i64bigger(a,b) ((a) > (b))

#define i64max(a,b) ( ((a)>(b)) ? (a) : (b) )
#define i64min(a,b) ( ((a)<(b)) ? (a) : (b) )

#define db_i64div32(q,d) ((double)(q) / (double)(d))
#define i_i64divdb(q,d) ( (int)((q) / (d)) )

#define i64add64(a, b) a += b
#define i64add32(a, b) i64add64(a, (int64)(b))

#define fwrite64(i, fp) fwrite(&i, sizeof(int64), 1, fp)

#define fread64(i, fp, read) read = fread(&i, sizeof(int64), 1, fp)



#endif /* HAVE_64MATH */



#ifndef HAVE_64PRINT_COMMAS

/* note: output needs to be deallocated */
char *strint64(const int64 i);

/* note: output needs to be deallocated */
char *strint32(const dword i);

#endif

#endif /* __BIGNUM_H */

