#include <fstream>
#include <stdio.h>
#include "conn_pool/DBPoolContainer.hh"
#include "thread_pool/DBThreadPool.hh"
#include "DBBalancer.hh"
#include "config/DBBalancerConfig.hh"
#include "method_objects/DBDoConnectionMO.hh"
#include "method_objects/DBManagementMO.hh"


DBBalancer::DBBalancer(DBBalancerConfig *config) {

  // We should substitute all these instantiations by three Singletons so they could
  // be easily reached. The same will occur with DBBalancerConfig class.

  _config = config;
  _dbpc = new DBPoolContainer(_config, config->getMode());
  _threadPool = new DBThreadPool(config->getDaemonInitThreads(),config->getDaemonMinThreads(),config->getDaemonMaxThreads());

  // Starting the connection Growing/Reaping/Testing thread.
  unsigned int delay = _config->getDaemonReaperDelay();
  if (delay>0) {
    _managementThread = new DBManagementMO(this,delay);
    _threadPool->submit(_managementThread);
  }
  
}

DBBalancer::~DBBalancer() {
  
  ACE_DEBUG((LM_DEBUG,"(%t,%T) Destroying DBBalancer.\n"));

  if (_config->getDaemonReaperDelay()>0) {
    _managementThread->shutdown();
  }

  //delete _managementThread;
  delete _threadPool;
  // Make sure that NO thread is using POOLS.
  delete _dbpc;
  ACE_DEBUG((LM_DEBUG,"(%t,%T) Destroyed DBBalancer.\n"));

}

// This is the main request processing method, called by the Daemon.

void DBBalancer::processConnection(int socket) {

  _threadPool->submit(new DBDoConnectionMO(_dbpc,socket));

}



/*
void DBBalancer::checkmem(string message) {

  char file[127];
  string tmp;
  int ncampo = 23;

  sprintf(file,"/proc/%d/stat",getpid());
  ifstream f(file);
  for (int i=0;i<ncampo;i++) f >> tmp;
  f.close();

  ACE_DEBUG((LM_DEBUG,"DBBalancerMEM: (%s) (pid= %d, mem=#%s#) ",message.c_str(),getpid(),tmp.c_str()));

}
*/
