#include <string>
#include <iostream>
#include <sys/socket.h>
#include <sys/un.h>

using std::string;

class DBBalancer;
class DBBalancerConfig;

class DBBalancerDaemon {

public:

  DBBalancerDaemon(int argc, char **argv);
  ~DBBalancerDaemon();
  void hello();
  void init();
  void run ();
  void help();
  void usage();
  int daemonize();
  void shutdown(int returnCode);

private:

  void processCommandLineParameters(int argc, char **argv);  
  void initLogger(string logFile);
  int createServerSocket(string host, int port);
  int createInetServerSocket(string host, int port);
  int createUnixServerSocket(int port);
  bool testUnixSocketPath(char *path);
  void savePid(DBBalancerConfig *config);

  DBBalancer* _db;
  DBBalancerConfig *_config;

  // Daemon attributes
  string _host;
  int _port;
  long _it;
  bool _debug;
  bool _run;
  unsigned int _mode;
  ofstream *_logFile; // Stream used if we define a "real file" to log.
  sockaddr_in _s_in;
  sockaddr_un _s_un;

  // CommandLine parameters
  string _config_file;
  string _unix_socket_path;
  string _pid_file_path;
  
};

