#include <string>
#include <fstream>

#include <ace/Synch.h>
#include <ace/Log_Msg.h>

#include "DBBalancerConfig.hh"


// WARNING: This class is not thread-safe. There shouldn't be any problem as it's only called during object
// inicialization (which is single-threaded) but maybe in a future could be desirable that feature.

class DBHostConfig;
class DBBalancerTxtConfig: public virtual DBBalancerConfig {

public:
  
  DBBalancerTxtConfig(string txtFile, string unixSocketBasePath="/tmp");

  ~DBBalancerTxtConfig();

  // DBBalancerConfig interface methods *****************************************

  // <daemon>
  unsigned int getDaemonReaderPort() { return _readerPort; };
  unsigned int getDaemonWriterPort() { return _writerPort; };
  string getDaemonHost() { return _host; };
  bool getWriterTransactionPerRequest() { return _writerTransactionPerRequest; };

  unsigned int getDaemonInitThreads() { return _initThreads; };
  unsigned int getDaemonMaxThreads() { return _maxThreads; };
  unsigned int getDaemonMinThreads() { return _minThreads; };

  unsigned int getInitDbConnections() { return _initDbConnections; };
  unsigned int getMinDbConnections() { return _minDbConnections; };
  unsigned int getMaxDbConnections() { return _maxDbConnections; };

  unsigned int getDaemonReaperDelay() { return _reaperDelay; };
  string getDaemonUser() { return _daemonUser; };
  string getDaemonPassword() { return _daemonPassword; };
  string getDaemonDbName() { return _daemonDbName; };
  string getDaemonAuthMethod() { return _daemonAuthMethod; };
  string getDaemonLogFile() { return _daemonLogFile; };

  string getUnixSocketBasePath() { return _unixSocketBasePath; };
  void setUnixSocketBasePath(string path) {  _unixSocketBasePath=path; };
  string getPidFileBasePath() { return _pidFileBasePath; };
  void setPidFileBasePath(string path) {  _pidFileBasePath = path; };

  unsigned int getMode() { return _mode; };
  void setMode(unsigned int mode) { _mode = mode; };

  // <machine> 1..n
  vector<DBHostConfig *> getHosts();

private:

  void parseFile(ifstream &file);
  void processNameValuePair(string name, string value);
  string trim(string st);
  void setDefaultValues();

  unsigned int _mode;
  unsigned int _readerPort;
  unsigned int _writerPort;
  string _host;
  bool _writerTransactionPerRequest;

  unsigned int _initThreads;
  unsigned int _minThreads;
  unsigned int _maxThreads;

  unsigned int _initDbConnections;
  unsigned int _minDbConnections;
  unsigned int _maxDbConnections;

  string _daemonUser;
  string _daemonPassword;
  string _daemonDbName;
  string _daemonAuthMethod;
  string _daemonLogFile;

  string _unixSocketBasePath;
  string _pidFileBasePath;

  unsigned int _reaperDelay;

  vector <DBHostConfig *> _hosts; 

};

