/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * gui_define.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: gui_define.h,v 1.1 2004/01/02 15:37:53 ericprev Exp $
*/

#ifndef __GUI_DEFINE_H__
#define __GUI_DEFINE_H__

/*
 meaning of () values:

wo => write only. This value should never been read to perform task. There is
      always another column in the same model containing the "unformatted"
      version. For numeric "unformatted" value, this column probably contains
      a "locale" formatted one. For string "unformatted" value, this column
      is the UTF-8 version (required to be displayed correctly).
		This column is displayed in a view.
org => read/write value. It is the value as it was received from the client
      (it is an "unformatted" value).  This column is NOT displayed in a view.
*/

/* list of all column of the "unattached_gdl_treeview" list */
enum
{
	UAG_FILENAME_COL=0,	/* char * (wo) */
	UAG_SIZE_COL,			/* char * (wo) */
	UAG_NB_SRC_COL,		/* guint : number of download sources */
	UAG_COMPRATIO_COL,	/* char *: download completion ratio (estimated) */
	UAG_FINALNAME_COL,	/* char * (wo): final filename */
	UAG_FILENAME,			/* char *: unformatted value of UAG_FILENAME_COL */
	UAG_COMPRATIO,			/* gfloat: unformatted value of UAG_COMPRATIO_COL */
	UAG_SIZE_AS_VAL,		/* gulong: unformated value of UAG_SIZE_COL */
	NB_UAG_COL
};

#endif
