/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * cmd2dc_gui2.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: cmd2dc_gui2.c,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/file.h>
#include <string.h>
#include <errno.h>
#include <glib.h>

/********************************************************************/
/* append all the given parameters to the file $(HOME)/.dc_gui2.url */
/********************************************************************/
int main(int argc, char **argv)
{
	int fd;
	GString *str;
	char *home_dir;
	int i;
	off_t end_pos;

	home_dir=getenv("HOME");
	str=g_string_new(home_dir==NULL?"":home_dir);
	g_string_append(str,"/.dc_gui2.cmd");

	fd=open(str->str,O_CREAT|O_WRONLY,S_IRUSR|S_IWUSR);
	if(fd==-1)
	{
		fprintf(stderr,"%s: open error: %s\n",argv[0],strerror(errno));
		exit(1);
	}

	if(flock(fd,LOCK_EX)==-1)
	{
		fprintf(stderr,"%s: lock error: %s\n",argv[0],strerror(errno));
		close(fd);
		exit(1);
	}

	if((end_pos=lseek(fd,0,SEEK_END))==-1)
	{
		fprintf(stderr,"%s: lseek error: %s\n",argv[0],strerror(errno));
		flock(fd,LOCK_UN);
		close(fd);
		exit(1);
	}

	g_string_assign(str,"");
	for(i=1;i<argc;i++)
	{
		g_string_append(str,argv[i]);
		g_string_append_c(str,'\n');
	}

	if(write(fd,str->str,str->len)!=str->len)
	{
		fprintf(stderr,"%s: write error: %s\n",argv[0],strerror(errno));
		if(ftruncate(fd,end_pos)!=0)
		{
			fprintf(stderr,"%s: truncate error: %s\n",argv[0],strerror(errno));
		}
		flock(fd,LOCK_UN);
		close(fd);
		exit(1);
	}

	flock(fd,LOCK_UN);
	close(fd);
	exit(0);
}

