/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * sound.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: sound.c,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "sound.h"
#include "misc_gtk.h"
#include "main.h"

typedef struct
{
	const char *toggle_widget_name;
	const char *entry_widget_name;
} SOUND_DESC;

static SOUND_DESC sound_desc[NB_SOUND_EVENT]={	{"end_of_dl_sound_checkbutton","end_of_dl_sound_entry"},	/* SOUND_END_OF_DOWNLOAD */
																{"privmsg_sound_checkbutton","privmsg_sound_entry"},		/* SOUND_PRIV_MSG */
																{"hublist_sound_checkbutton","hublist_sound_entry"}		/* SOUND_HUBLIST */
															};

/*******************************************************/
/* try to play the sound associated to the given event */
/*******************************************************/
void play_the_sound_of_event(SOUND_EVENT se)
{
	const char *fname;

	/* sound enabled ? */
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(main_window,"enable_sound_checkbutton")))==FALSE)
		return;
	
	/* this event enabled ? */
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(main_window,sound_desc[se].toggle_widget_name)))==FALSE)
		return;

	fname=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name(main_window,sound_desc[se].entry_widget_name)));
	if((fname!=NULL)&&(strlen(fname)))
	{
		gnome_sound_play(fname);
	}
}

