/* $Id: dedit.c,v 1.1.1.1 2000/10/13 06:45:02 kitame Exp $

  core code of DEdit

  Copyright (C) 1999  Takuo KITAME

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License with
  the Debian GNU/Linux distribution in file /usr/doc/copyright/GPL;
  if not, write to the Free Software Foundation, Inc., 59 Temple Place,
  Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <unistd.h>

#include "dedit.h"
#include "print.h"
#include "callbacks.h"
#include "find.h"
#include "file.h"
#include "mdi.h"
#include "prefs.h"

GnomeMDI *DEmdi;

static gboolean restarted = FALSE;
gint untitled_num;

/* session managment */
static gint save_state(GnomeClient        *client,
                gint                phase,
                GnomeRestartStyle   save_style,
                gint                shutdown,
                GnomeInteractStyle  interact_style,
                gint                fast,
                gpointer            client_data);

static gint client_die(GnomeClient *client, gpointer client_data);

static void about_cb (GtkWidget *widget, gpointer data);

GnomeUIInfo filemenu[] = {
    {GNOME_APP_UI_ITEM, 
     N_("_New"), N_("New Document"),
     add_doc_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
     'N', GDK_CONTROL_MASK, NULL},
    {GNOME_APP_UI_ITEM, 
     N_("_Open"), N_("Open Document"),
     file_open_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
     'O', GDK_CONTROL_MASK, NULL},
    {GNOME_APP_UI_ITEM, 
     N_("_Save"), N_("Save Document"),
     save_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
     'S', GDK_CONTROL_MASK, NULL},
    {GNOME_APP_UI_ITEM, 
     N_("Save _As..."), N_("Save Document As..."),
     save_as_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS,
     0, 0, NULL},
    GNOMEUIINFO_SEPARATOR,
    {GNOME_APP_UI_ITEM, 
     N_("_Print..."), N_("Print Document..."),
     dedit_print_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT,
     'P', GDK_CONTROL_MASK, NULL},
    GNOMEUIINFO_SEPARATOR,
    {GNOME_APP_UI_ITEM, 
     N_("_Close"), N_("Close Window"),
     remove_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
     'D', GDK_CONTROL_MASK, NULL},
    {GNOME_APP_UI_ITEM, 
     N_("_Quit"), N_("Quit DEdit"),
     quit_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT,
     'Q', GDK_CONTROL_MASK, NULL},
    GNOMEUIINFO_END
};

/* edit menu */
GnomeUIInfo editmenu[] = {
    {GNOME_APP_UI_ITEM, 
     N_("_Cut"), N_("Cut Selected Text"),
     dedit_cut_cb, NULL, NULL,
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CUT,
     'X', GDK_CONTROL_MASK, NULL},
    {GNOME_APP_UI_ITEM, 
     N_("C_opy"), N_("Cut Selected Text"),
     dedit_copy_cb, NULL, NULL,
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_COPY,
     'C', GDK_CONTROL_MASK, NULL},
    {GNOME_APP_UI_ITEM, 
     N_("_Paste"), N_("Paste Selected Text"),
     dedit_paste_cb, NULL, NULL,
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PASTE,
     'V', GDK_CONTROL_MASK, NULL},
    {GNOME_APP_UI_ITEM, 
     N_("Select _All"), N_("Select All Text"),
     dedit_select_all_cb, NULL, NULL,
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
     'A', GDK_CONTROL_MASK, NULL},
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_MENU_FIND_ITEM(find_dialog, NULL),
    GNOMEUIINFO_MENU_FIND_AGAIN_ITEM(find_again_cb, NULL),
    GNOMEUIINFO_SEPARATOR,
    /*    {GNOME_APP_UI_TOGGLEITEM, N_("_Fixed Font"), 
     N_("Display text with a fixed font"),
     fixed_cb, NULL, NULL,
     0, 0, 'f', 
     GDK_CONTROL_MASK, NULL }, */
    GNOMEUIINFO_MENU_PREFERENCES_ITEM(prefs_create_dialog, NULL),
    GNOMEUIINFO_END
};

GnomeUIInfo emptymenu[] = {
    GNOMEUIINFO_END
};

/* help menu */
GnomeUIInfo helpmenu[] = {
    GNOMEUIINFO_MENU_ABOUT_ITEM(about_cb,NULL),
    // GNOMEUIINFO_HELP("help-browser"),
    GNOMEUIINFO_END
};

/* menu bar */
GnomeUIInfo mainmenu[] = {
    GNOMEUIINFO_SUBTREE(N_("_File"), filemenu),
    GNOMEUIINFO_SUBTREE(N_("_Edit"), editmenu),
    GNOMEUIINFO_SUBTREE(N_("_Windows"), emptymenu),
    GNOMEUIINFO_SUBTREE(N_("_Help"), helpmenu),
    GNOMEUIINFO_END
};

/* Tool bar */
GnomeUIInfo toolbar[] = {
    {GNOME_APP_UI_ITEM, N_("New"), N_("New Document"),
     add_doc_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_NEW,
     0, 0, NULL},
    {GNOME_APP_UI_ITEM, N_("Open"), N_("Open Document"),
     file_open_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_OPEN,
     0, 0, NULL},
    {GNOME_APP_UI_ITEM, N_("Save"), N_("Save Document"),
     save_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SAVE,
     0, 0, NULL},
    {GNOME_APP_UI_ITEM, N_("Save As"), N_("Save Document As..."),
     save_as_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SAVE_AS,
     0, 0, NULL},
    {GNOME_APP_UI_ITEM, N_("Print"), N_("Print Document..."),
     dedit_print_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PRINT,
     0, 0, NULL},
    GNOMEUIINFO_SEPARATOR,
    {GNOME_APP_UI_ITEM, N_("Cut"), N_("Cut Selected Text"),
     dedit_cut_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CUT,
     0, 0, NULL},
    {GNOME_APP_UI_ITEM, N_("Copy"), N_("Copy Selected Text"),
     dedit_copy_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_COPY,
     0, 0, NULL},
    {GNOME_APP_UI_ITEM, N_("Paste"), N_("Paste Buffered Text"),
     dedit_paste_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PASTE,
     0, 0, NULL},
    GNOMEUIINFO_SEPARATOR,
    {GNOME_APP_UI_ITEM, N_("Preference"), N_("Preference"),
     prefs_create_dialog, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PREFERENCES,
     0, 0, NULL},
    {GNOME_APP_UI_ITEM, N_("Close"), N_("Close Window"),
     remove_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLOSE,
     0, 0, NULL},
    {GNOME_APP_UI_ITEM, N_("Quit"), N_("Quit DEdit"),
     quit_cb, NULL, NULL, 
     GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_EXIT,
     0, 0, NULL},
    GNOMEUIINFO_END
};

const struct poptOption options[] = {
    {NULL, '\0', 0, NULL, 0}
};

/* About Box */
static void
about_cb(GtkWidget *widget, gpointer data)
{
    GtkWidget *about;
    const gchar *authors[] = {
        _("Takuro KITAME  (main code)"),
        _("Fumitoshi UKAI (man pages)"),
        NULL };
      
#ifdef TRACE_FUNC
    printf("about_cb()\n");
#endif
  
    about = gnome_about_new ( "DEdit", 
                              VERSION,
                              "Copyright (C) 1999 Project Dice.",
                              authors,
                              _("DEdit The Simple Editor for Dice.")
                              ,
                              NULL);
    gtk_window_set_modal(GTK_WINDOW(about), TRUE);
    gtk_window_position(GTK_WINDOW(about), GTK_WIN_POS_MOUSE);
    gtk_widget_show (about);
    
    return;
}

static void
restore_session(GnomeClient *client)
{
    gint x, y, h, w;
    
    gnome_config_push_prefix(gnome_client_get_config_prefix(client));
    
    x     = gnome_config_get_int  ("Geometry/x");
    y     = gnome_config_get_int  ("Geometry/y");
    w     = gnome_config_get_int  ("Geometry/w");
    h     = gnome_config_get_int  ("Geometry/h");
    
    gtk_widget_set_uposition (GTK_WIDGET(DEmdi), x, y);
    gtk_widget_set_usize     (GTK_WIDGET(DEmdi), w, h);
    
    restarted = 
        gnome_mdi_restore_state(DEmdi, "Session",
                                (GnomeMDIChildCreator)dedit_new_document);
    
    gnome_config_pop_prefix ();
    
    return;
}

int
main(int argc, char **argv)
{
    GnomeClient *client;
    gchar **cl_files;
    poptContext ctx;
    
#ifdef TRACE_FUNC
    printf("main()\n");
#endif

    untitled_num = 1;

    if(getenv("LANG") == NULL)
        setenv("LANG", "C", 1);

    if(strcmp(getenv("LANG"), "C") == 0 || 
       strcmp(getenv("LANG"), "") == 0)
        unsetenv("XMODIFIERS");
    
    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain (PACKAGE);
    
    gnome_init_with_popt_table("dedit", VERSION, 
                               argc, argv, options, 0, &ctx);
    
    prefs_load();
    
    /* Gnome Master Client */
    client = gnome_master_client();
    
    gtk_signal_connect (GTK_OBJECT (client), "save_yourself",
                        GTK_SIGNAL_FUNC (save_state), (gpointer) argv[0]);

    gtk_signal_connect (GTK_OBJECT (client), "die",
                        GTK_SIGNAL_FUNC (client_die), NULL);
    
    DEmdi = GNOME_MDI(gnome_mdi_new("dedit", "DEdit"));

    gnome_mdi_set_mode(DEmdi, prefs->mdimode);
    DEmdi->tab_pos = prefs->tabpos;

    gnome_mdi_set_menubar_template(DEmdi, mainmenu);
    gnome_mdi_set_toolbar_template(DEmdi, toolbar);

    gnome_mdi_set_child_menu_path(DEmdi, _("_File"));
    gnome_mdi_set_child_list_path(DEmdi, _("_Windows/"));
    
    gtk_signal_connect(GTK_OBJECT(DEmdi), "remove_child",
                       GTK_SIGNAL_FUNC(remove_child_handler), NULL);


    gtk_signal_connect(GTK_OBJECT(DEmdi), "destroy",
                       GTK_SIGNAL_FUNC(cleanup_cb), NULL);
    
    gtk_signal_connect(GTK_OBJECT(DEmdi), "child_changed", 
                       GTK_SIGNAL_FUNC(child_changed_cb), NULL);

#ifdef USE_DND
    gtk_signal_connect(GTK_OBJECT(DEmdi), "app_created", 
                       GTK_SIGNAL_FUNC(app_created_cb), NULL);
#endif

    /* restore state from previous session */
    if(gnome_client_get_flags(client) & GNOME_CLIENT_RESTORED) {
        restore_session(client);
    }

    if (!restarted)
        gnome_mdi_open_toplevel(DEmdi);
    
    cl_files = (gchar **)poptGetArgs(ctx);
    if(argc > 1){
        while(cl_files && *cl_files) {
            dedit_new_document(NULL, *cl_files);
            cl_files++;
        }
    } else
        dedit_new_document(NULL, NULL);
    
    poptFreeContext(ctx);
    dedit_set_prefs_toolbar();
    gtk_main();

    return 0;
}

/* Session management */
static gint
save_state(GnomeClient        *client,
           gint                phase,
           GnomeRestartStyle   save_style,
           gint                shutdown,
           GnomeInteractStyle  interact_style,
           gint                fast,
           gpointer            client_data)
{
    
    GtkWidget *app;
    gchar *prefix = gnome_client_get_config_prefix(client);
    gchar *argv[] = { "rm", "-r", NULL };
    gint x, y, w, h;
    
    app = GTK_WIDGET(gnome_mdi_get_app_from_view(DEmdi->active_view));

    /* The only state that gnome-hello has is the window geometry. 
       Get it. */
    gdk_window_get_geometry(app->window, &x, &y, &w, &h, NULL);
    
    /* Save the state using gnome-config stuff. */
    gnome_config_push_prefix(prefix);
    g_print("%s\n", prefix);
    
    gnome_config_set_int("Geometry/x", x);
    gnome_config_set_int("Geometry/y", y);
    gnome_config_set_int("Geometry/w", w);
    gnome_config_set_int("Geometry/h", h);
	gnome_mdi_save_state (DEmdi, "MDI Session");
    
    gnome_config_pop_prefix ();
    gnome_config_sync();
    
    /* Here is the real SM code. We set the argv to the parameters needed
       to restart/discard the session that we've just saved and call
       the gnome_session_set_*_command to tell the session manager it. */
    argv[2] = gnome_config_get_real_path(prefix);
    gnome_client_set_discard_command(client, 3, argv);
    
    /* Set commands to clone and restart this application.  Note that we
       use the same values for both -- the session management code will
       automatically add whatever magic option is required to set the
       session id on startup.  */
    argv[0] = (gchar *)client_data;
    gnome_client_set_clone_command(client, 1, argv);
    gnome_client_set_restart_command(client, 1, argv);
    
    return TRUE;
}

static gint
client_die(GnomeClient *client, gpointer client_data)
{
    /* Just exit in a friendly way.  We don't need to save any state
       here, because the session manager should have sent us a
       save_yourself-message before.  */
    gtk_exit (0);
    
    return FALSE;
}
