/* drawgrace.cpp
 *
 * Functions for drawing tuplet indications
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001, 2002 Adam Tee
 */

#include "utils.h"		/* Includes <gdk.h> */
#include <denemo/denemo.h>

void
draw_gracebracket (GdkPixmap * pixmap, GdkGC * gc, GdkFont * font,
		   gint xx, gint y, mudelaobject * theobj)
{
  static GdkFont *gracebracketfont = NULL;
  static GString *graceopentext;

  if (!gracebracketfont)
    {
      gracebracketfont =
	gdk_fontset_load
	("-*-helvetica-medium-r-normal-*-12-*-*-*-*-*-iso8859-*");
      if (!gracebracketfont)
	gracebracketfont = font;
      graceopentext = g_string_new (NULL);
    }
  if (theobj->type == GRACE_START)
    {
      g_string_sprintf (graceopentext, _("Grace"));
      gdk_draw_text (pixmap, gracebracketfont, gc, xx, y - 4,
		     graceopentext->str, graceopentext->len);
    }
  else if (theobj->type == GRACE_END)
    gdk_draw_text (pixmap, gracebracketfont, gc, xx, y - 4, _("End grace"),
		   10);
}
