/* print.cpp
 * 
 * basic printing support for GNU Denemo
 * outputs to a dvi file
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2001, 2002 Adam Tee
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>

#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_WAIT_H
#include <wait.h>
#endif

#include <errno.h>

#include "print.h"
#include "prefops.h"
#include "exportmudela.h"
#include "utils.h"


/*  Print function 
 *  Save file in lilypond format
 *  Fork and run lilypond
 *  Fork and run tex
 *  Fork and run xdvi
 */
void
print (GtkAction *action, gpointer callback_data)
{
  static GString *filename = NULL;
  static GString *passtosystem;
  pid_t pid;
  struct scoreinfo *si = (struct scoreinfo *) callback_data;

  if (!filename)
    {
      filename = g_string_new (locatedotdenemo ());
      g_string_append (filename, "/denemoprint");
      passtosystem = g_string_new (NULL);
    }

#ifdef G_OS_WIN32
  pid = -1;
#else
  pid = fork ();
#endif

  if (pid == -1)
    {
      fprintf (stderr, "%s: Failed to fork()\n", strerror (errno));
      return;
    }
  else if (pid == 0)
    {
      exportmudela (filename->str, si, 0, 0);
      g_string_assign (passtosystem, si->prefs->lilypath->str);
      g_string_append (passtosystem, " -o ");
      g_string_append (passtosystem, filename->str);
      g_string_append (passtosystem, " ");
      g_string_append (passtosystem, filename->str);
      g_string_append (passtosystem, ".ly");

      if (system (passtosystem->str))
	_exit (0);

      g_string_assign (passtosystem, "tex ");
      g_string_append (passtosystem, filename->str);
      g_string_append (passtosystem, ".tex");
      if (system (passtosystem->str))
	_exit (0);

	
      g_string_assign (passtosystem, "xdvi ");
      g_string_append (passtosystem, filename->str);
      g_string_append (passtosystem, ".dvi");
      system ("xdvi denemoprint.dvi");


      _exit (0);
    }


}
