/*
 * Tests for geometry functions.
 */

#include <libart_lgpl/art_affine.h>
#include <diacanvas/dia-geometry.h>
#include "unit-test.h"

void
setup (void)
{
}

void
teardown (void)
{
}

TEST_BEGIN (DiaGeometry, setup, teardown)

TEST_NEW (dia_distance_point_point)
{
	DiaPoint p1 = { 0.0, 2.0};
	DiaPoint p2 = { 0.0, 0.0};

	TESTFL (dia_distance_point_point (&p1, &p2), 2.0);
}

TEST_NEW (dia_distance_point_point_manhattan)
{
	DiaPoint p1 = { 0.0, 2.0};
	DiaPoint p2 = { 0.0, 0.0};

	TESTFL (dia_distance_point_point_manhattan (&p1, &p2), 2.0);
}

TEST_NEW (dia_distance_rectangle_point)
{
	DiaRectangle r = { 0.0, 0.0, 2.0, 2.0 };
	DiaPoint p1 = { 1.0, 1.0 }; /* inside the rectangle */
	DiaPoint p2 = { 2.0, 2.0 }; /* On the border */
	DiaPoint p3 = { 4.0, 1.0 }; /* outside */

	TESTFL (dia_distance_rectangle_point (&r, &p1), 0.0);
	TESTFL (dia_distance_rectangle_point (&r, &p2), 0.0);
	TESTFL (dia_distance_rectangle_point (&r, &p3), 2.0);
}

TEST_NEW (dia_distance_line_point)
{
	DiaPoint s1 = { 0.0, 0.0 }, e1 = { 2.0, 4.0 };
	DiaPoint p1 = { 3.0, 4.0 },
		 p2 = { -1.0, 0.0 },
		 p3 = { 1.0, 2.0 },
		 p4 = {2.0, 2.0};
	DiaPoint pol;

	TESTFL (dia_distance_line_point (&s1, &e1, &p1, 0.0,
				DIA_CAP_ROUND, &pol), 1.0);
	TESTFL (pol.x, 2.0);
	TESTFL (pol.y, 4.0);

	TESTFL (dia_distance_line_point (&s1, &e1, &p2, 0.0,
				DIA_CAP_ROUND, &pol), 1.0);
	TESTFL (pol.x, 0.0);
	TESTFL (pol.y, 0.0);

	TESTFL (dia_distance_line_point (&s1, &e1, &p3, 0.0,
				DIA_CAP_ROUND, &pol), 0.0);
	TESTFL (pol.x, 1.0);
	TESTFL (pol.y, 2.0);

	TESTFL (dia_distance_line_point (&s1, &e1, &p4, 2.0,
				DIA_CAP_ROUND, &pol), 0.0);
	TESTFL (pol.x, 1.2);
	TESTFL (pol.y, 2.4);

	TESTFL (dia_distance_line_point (&s1, &e1, &p2, 2.0,
				DIA_CAP_BUTT, &pol), 1.0);
	TESTFL (pol.x, 0.0);
	TESTFL (pol.y, 0.0);

	TESTFL (dia_distance_line_point (&s1, &e1, &p2, 2.0,
				DIA_CAP_SQUARE, &pol), 0.0);
	TESTFL (pol.x, 0.0);
	TESTFL (pol.y, 0.0);

	TESTFL (dia_distance_line_point (&s1, &e1, &p2, 2.0,
				DIA_CAP_ROUND, &pol), 0.0);
	TESTFL (pol.x, 0.0);
	TESTFL (pol.y, 0.0);
}

TEST_NEW (dia_intersection_line_line)
{
	DiaPoint p1 = {0.0, 0.0},
		 p2 = {10.0, 10.0},
		 p3 = {0.0, 10.0},
		 p4 = {10.0, 0.0};
	DiaPoint pout;
	gboolean res;

	res = dia_intersection_line_line (&p1, &p2, &p3, &p4, &pout);
	TEST (res == TRUE);
	TESTFL (pout.x, 5.0);
	TESTFL (pout.y, 5.0);
		
	res = dia_intersection_line_line (&p1, &p3, &p2, &p4, &pout);
	TEST (res == FALSE);
		
	res = dia_intersection_line_line (&p1, &p3, &p1, &p4, &pout);
	TEST (res == TRUE);
	TESTFL (pout.x, 0.0);
	TESTFL (pout.y, 0.0);
}

TEST_NEW (dia_intersection_line_rectangle)
{
	DiaPoint p1 = {0.0,  0.0},
		 p2 = {10.0, 10.0},
		 p3 = {0.0, 10.0},
		 p4 = {5.0, 5.0};
	DiaRectangle r = {2.0, 2.0, 6.0, 6.0};
	DiaPoint pout[2];
	gint n_int;

	n_int = dia_intersection_line_rectangle (&p1, &p2, &r, pout);
	TEST (n_int == 2);
	TESTFL (pout[0].x, 2.0);
	TESTFL (pout[0].y, 2.0);
	TESTFL (pout[1].x, 6.0);
	TESTFL (pout[1].y, 6.0);

	n_int = dia_intersection_line_rectangle (&p1, &p3, &r, pout);
	TEST (n_int == 0);

	n_int = dia_intersection_line_rectangle (&p1, &p4, &r, pout);
	TEST (n_int == 1);
	TESTFL (pout[0].x, 2.0);
	TESTFL (pout[0].y, 2.0);
}

TEST_NEW (dia_intersection_rectangle_rectangle)
{
	DiaRectangle r1 = {0.0, 0.0, 10.0, 10.0},
		     r2 = {12.0, 0.0, 15.0, 5.0},
		     r3 = {-2.0, -1.0, 5.0, 5.0};
	gboolean res;
	
	res = dia_intersection_rectangle_rectangle (&r1, &r2);
	TEST (res == FALSE);
	
	res = dia_intersection_rectangle_rectangle (&r1, &r3);
	TEST (res == TRUE);
}

TEST_NEW (dia_rectangle_add_point)
{
	DiaRectangle r = {0.0, 0.0, 1.0, 1.0};
	DiaPoint p1 = {0.5, 0.5},
		 p2 = {5.0, 5.0},
		 p3 = {-5.0, -5.0};
	
	dia_rectangle_add_point (&r, &p1);
	TESTFL (r.top, 0.0);
	TESTFL (r.left, 0.0);
	TESTFL (r.bottom, 1.0);
	TESTFL (r.right, 1.0);
	
	dia_rectangle_add_point (&r, &p2);
	TESTFL (r.top, 0.0);
	TESTFL (r.left, 0.0);
	TESTFL (r.bottom, 5.0);
	TESTFL (r.right, 5.0);
	
	dia_rectangle_add_point (&r, &p3);
	TESTFL (r.top, -5.0);
	TESTFL (r.left, -5.0);
	TESTFL (r.bottom, 5.0);
	TESTFL (r.right, 5.0);
}

TEST_END ()
