/*
 * Tests for shape functions.
 */

#include <libart_lgpl/art_affine.h>
#include <diacanvas/dia-shape.h>
#include "unit-test.h"

void
setup (void)
{
}

void
teardown (void)
{
}

TEST_BEGIN (DiaShape, setup, teardown)

TEST_NEW (dia_dash_style)
{
	gdouble a = 5;
	DiaDashStyle *style = dia_dash_style_new (1, a);

	TEST (style->n_dash == 1);
	TESTFL (style->dash[0], 5.0);
}

TEST_NEW (dia_dash_style_2)
{
	DiaDashStyle *style = dia_dash_style_new (5, 1.0, 2.0, 3.0, 4.0, 5.0);

	TEST (style->n_dash == 5);
	TESTFL (style->dash[0], 1.0);
	TESTFL (style->dash[1], 2.0);
	TESTFL (style->dash[2], 3.0);
	TESTFL (style->dash[3], 4.0);
	TESTFL (style->dash[4], 5.0);
}

TEST_END ()
