/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio;

import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.action.CustomAction;
import de.xeinfach.kafenio.action.FormatAction;
import de.xeinfach.kafenio.action.IndentAction;
import de.xeinfach.kafenio.action.ListAutomationAction;
import de.xeinfach.kafenio.action.ServerImageAction;
import de.xeinfach.kafenio.action.SpecialCharAction;
import de.xeinfach.kafenio.action.ToggleCaseAction;
import de.xeinfach.kafenio.util.LeanLogger;
import java.awt.Color;
import java.util.Hashtable;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;

public class KafenioPanelActions {
    private static LeanLogger log = new LeanLogger("KafenioPanelActions.class");
    private static final String FONTSIZE_KEY = "size";
    private KafenioPanel parent;
    private CustomAction actionSelectFont;
    private CustomAction actionClearFormat;
    private ServerImageAction actionInsertServerImage;
    private CustomAction actionInsertHyperlink;
    private CustomAction actionAlignLeft;
    private CustomAction actionAlignCenter;
    private CustomAction actionAlignRight;
    private CustomAction actionAlignJustified;
    private CustomAction actionFontSize1;
    private CustomAction actionFontSize2;
    private CustomAction actionFontSize3;
    private CustomAction actionFontSize4;
    private CustomAction actionFontSize5;
    private CustomAction actionFontSize6;
    private CustomAction actionFontSize7;
    private CustomAction actionFontCustomColor;
    private IndentAction actionIndentLeft;
    private IndentAction actionIndentRight;
    private FormatAction actionFontStrike;
    private FormatAction actionFontSuperscript;
    private FormatAction actionFontSubscript;
    private FormatAction actionAddParagraph;
    private FormatAction actionHeading1;
    private FormatAction actionHeading2;
    private FormatAction actionHeading3;
    private FormatAction actionHeading4;
    private FormatAction actionHeading5;
    private FormatAction actionHeading6;
    private FormatAction actionAddListItem;
    private FormatAction actionSpan;
    private FormatAction actionTT;
    private FormatAction actionEmphasis;
    private FormatAction actionStrong;
    private FormatAction actionPre;
    private FormatAction actionBlockquote;
    private FormatAction actionFormatBig;
    private FormatAction actionFormatSmall;
    private StyledEditorKit.ForegroundAction actionFontColorYellow;
    private StyledEditorKit.ForegroundAction actionFontColorWhite;
    private StyledEditorKit.ForegroundAction actionFontColorTeal;
    private StyledEditorKit.ForegroundAction actionFontColorSilver;
    private StyledEditorKit.ForegroundAction actionFontColorRed;
    private StyledEditorKit.ForegroundAction actionFontColorPurple;
    private StyledEditorKit.ForegroundAction actionFontColorOlive;
    private StyledEditorKit.ForegroundAction actionFontColorNavy;
    private StyledEditorKit.ForegroundAction actionFontColorMaroon;
    private StyledEditorKit.ForegroundAction actionFontColorLime;
    private StyledEditorKit.ForegroundAction actionFontColorGreen;
    private StyledEditorKit.ForegroundAction actionFontColorGray;
    private StyledEditorKit.ForegroundAction actionFontColorFuschia;
    private StyledEditorKit.ForegroundAction actionFontColorBlue;
    private StyledEditorKit.ForegroundAction actionFontColorBlack;
    private StyledEditorKit.ForegroundAction actionFontColorAqua;
    private ListAutomationAction actionListUnordered;
    private ListAutomationAction actionListOrdered;
    private SpecialCharAction actionInsertCharacter;
    private StyledEditorKit.BoldAction actionFontBold;
    private StyledEditorKit.ItalicAction actionFontItalic;
    private StyledEditorKit.UnderlineAction actionFontUnderline;
    private ToggleCaseAction actionToggleCase;

    public KafenioPanelActions(KafenioPanel kafenioPanel) {
        this.parent = kafenioPanel;
        log.debug("creating shared actions...");
        this.actionFontBold = new StyledEditorKit.BoldAction();
        this.actionFontItalic = new StyledEditorKit.ItalicAction();
        this.actionFontUnderline = new StyledEditorKit.UnderlineAction();
        this.actionFontStrike = new FormatAction(this.parent, this.getString("FontStrike"), HTML.Tag.STRIKE);
        this.actionFontSuperscript = new FormatAction(this.parent, this.getString("FontSuperscript"), HTML.Tag.SUP);
        this.actionFontSubscript = new FormatAction(this.parent, this.getString("FontSubscript"), HTML.Tag.SUB);
        this.actionListUnordered = new ListAutomationAction(this.parent, this.getString("ListUnordered"), HTML.Tag.UL);
        this.actionListOrdered = new ListAutomationAction(this.parent, this.getString("ListOrdered"), HTML.Tag.OL);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("align", "left");
        this.actionAlignLeft = new CustomAction(this.parent, this.getString("AlignLeft"), HTML.Tag.P, hashtable);
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("align", "center");
        this.actionAlignCenter = new CustomAction(this.parent, this.getString("AlignCenter"), HTML.Tag.P, hashtable2);
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        hashtable3.put("align", "right");
        this.actionAlignRight = new CustomAction(this.parent, this.getString("AlignRight"), HTML.Tag.P, hashtable3);
        Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
        hashtable4.put("align", "justify");
        this.actionAlignJustified = new CustomAction(this.parent, this.getString("AlignJustified"), HTML.Tag.DIV, hashtable4);
        this.actionIndentLeft = new IndentAction(this.parent, "deindent");
        this.actionIndentRight = new IndentAction(this.parent, "indent");
        Hashtable<String, String> hashtable5 = new Hashtable<String, String>();
        hashtable5.put("face", "");
        this.actionSelectFont = new CustomAction(this.parent, this.getString("FontSelect") + "...", HTML.Tag.FONT, hashtable5);
        this.actionClearFormat = new CustomAction(this.parent, this.getString("FormatClear"), new HTML.UnknownTag(""));
        this.actionInsertHyperlink = new CustomAction(this.parent, this.getString("InsertAnchor") + "...", HTML.Tag.A);
        this.actionInsertServerImage = new ServerImageAction(this.parent);
        this.actionInsertCharacter = new SpecialCharAction(this.parent, this.getString("InsertCharacter") + "...");
        this.actionToggleCase = new ToggleCaseAction(this.parent, this.getString("ToggleCase") + "...");
        this.actionAddParagraph = new FormatAction(this.parent, this.getString("AddParagraph"), HTML.Tag.P, "left");
        this.actionHeading1 = new FormatAction(this.parent, this.getString("Heading1"), HTML.Tag.H1);
        this.actionHeading2 = new FormatAction(this.parent, this.getString("Heading2"), HTML.Tag.H2);
        this.actionHeading3 = new FormatAction(this.parent, this.getString("Heading3"), HTML.Tag.H3);
        this.actionHeading4 = new FormatAction(this.parent, this.getString("Heading4"), HTML.Tag.H4);
        this.actionHeading5 = new FormatAction(this.parent, this.getString("Heading5"), HTML.Tag.H5);
        this.actionHeading6 = new FormatAction(this.parent, this.getString("Heading6"), HTML.Tag.H6);
        this.actionAddListItem = new FormatAction(this.parent, this.getString("ListItem"), HTML.Tag.LI);
        this.actionBlockquote = new FormatAction(this.parent, this.getString("FormatBlockquote"), HTML.Tag.BLOCKQUOTE);
        this.actionPre = new FormatAction(this.parent, this.getString("FormatPre"), HTML.Tag.PRE);
        this.actionStrong = new FormatAction(this.parent, this.getString("FormatStrong"), HTML.Tag.STRONG);
        this.actionEmphasis = new FormatAction(this.parent, this.getString("FormatEmphasis"), HTML.Tag.EM);
        this.actionTT = new FormatAction(this.parent, this.getString("FormatTT"), HTML.Tag.TT);
        this.actionSpan = new FormatAction(this.parent, this.getString("FormatSpan"), HTML.Tag.SPAN);
        hashtable5 = new Hashtable();
        hashtable5.put(FONTSIZE_KEY, "1");
        this.actionFontSize1 = new CustomAction(this.parent, this.getString("FontSize1"), HTML.Tag.FONT, hashtable5);
        hashtable5 = new Hashtable();
        hashtable5.put(FONTSIZE_KEY, "2");
        this.actionFontSize2 = new CustomAction(this.parent, this.getString("FontSize2"), HTML.Tag.FONT, hashtable5);
        hashtable5 = new Hashtable();
        hashtable5.put(FONTSIZE_KEY, "3");
        this.actionFontSize3 = new CustomAction(this.parent, this.getString("FontSize3"), HTML.Tag.FONT, hashtable5);
        hashtable5 = new Hashtable();
        hashtable5.put(FONTSIZE_KEY, "4");
        this.actionFontSize4 = new CustomAction(this.parent, this.getString("FontSize4"), HTML.Tag.FONT, hashtable5);
        hashtable5 = new Hashtable();
        hashtable5.put(FONTSIZE_KEY, "5");
        this.actionFontSize5 = new CustomAction(this.parent, this.getString("FontSize5"), HTML.Tag.FONT, hashtable5);
        hashtable5 = new Hashtable();
        hashtable5.put(FONTSIZE_KEY, "6");
        this.actionFontSize6 = new CustomAction(this.parent, this.getString("FontSize6"), HTML.Tag.FONT, hashtable5);
        hashtable5 = new Hashtable();
        hashtable5.put(FONTSIZE_KEY, "7");
        this.actionFontSize7 = new CustomAction(this.parent, this.getString("FontSize7"), HTML.Tag.FONT, hashtable5);
        this.actionFormatBig = new FormatAction(this.parent, this.getString("FormatBig"), HTML.Tag.BIG);
        this.actionFormatSmall = new FormatAction(this.parent, this.getString("FormatSmall"), HTML.Tag.SMALL);
        hashtable5 = new Hashtable();
        hashtable5.put("color", "black");
        this.actionFontCustomColor = new CustomAction(this.parent, this.getString("CustomColor") + "...", HTML.Tag.FONT, hashtable5);
        this.actionFontColorAqua = new StyledEditorKit.ForegroundAction(this.getString("ColorAqua"), new Color(0, 255, 255));
        this.actionFontColorBlack = new StyledEditorKit.ForegroundAction(this.getString("ColorBlack"), new Color(0, 0, 0));
        this.actionFontColorBlue = new StyledEditorKit.ForegroundAction(this.getString("ColorBlue"), new Color(0, 0, 255));
        this.actionFontColorFuschia = new StyledEditorKit.ForegroundAction(this.getString("ColorFuschia"), new Color(255, 0, 255));
        this.actionFontColorGray = new StyledEditorKit.ForegroundAction(this.getString("ColorGray"), new Color(128, 128, 128));
        this.actionFontColorGreen = new StyledEditorKit.ForegroundAction(this.getString("ColorGreen"), new Color(0, 128, 0));
        this.actionFontColorLime = new StyledEditorKit.ForegroundAction(this.getString("ColorLime"), new Color(0, 255, 0));
        this.actionFontColorMaroon = new StyledEditorKit.ForegroundAction(this.getString("ColorMaroon"), new Color(128, 0, 0));
        this.actionFontColorNavy = new StyledEditorKit.ForegroundAction(this.getString("ColorNavy"), new Color(0, 0, 128));
        this.actionFontColorOlive = new StyledEditorKit.ForegroundAction(this.getString("ColorOlive"), new Color(128, 128, 0));
        this.actionFontColorPurple = new StyledEditorKit.ForegroundAction(this.getString("ColorPurple"), new Color(128, 0, 128));
        this.actionFontColorRed = new StyledEditorKit.ForegroundAction(this.getString("ColorRed"), new Color(255, 0, 0));
        this.actionFontColorSilver = new StyledEditorKit.ForegroundAction(this.getString("ColorSilver"), new Color(192, 192, 192));
        this.actionFontColorTeal = new StyledEditorKit.ForegroundAction(this.getString("ColorTeal"), new Color(0, 128, 128));
        this.actionFontColorWhite = new StyledEditorKit.ForegroundAction(this.getString("ColorWhite"), new Color(255, 255, 255));
        this.actionFontColorYellow = new StyledEditorKit.ForegroundAction(this.getString("ColorYellow"), new Color(255, 255, 0));
        log.debug("...done.\nLoading config files and libraries...");
    }

    private String getString(String string) {
        return this.parent.getTranslation(string);
    }

    public CustomAction getActionAlignCenter() {
        return this.actionAlignCenter;
    }

    public CustomAction getActionAlignJustified() {
        return this.actionAlignJustified;
    }

    public CustomAction getActionAlignLeft() {
        return this.actionAlignLeft;
    }

    public CustomAction getActionAlignRight() {
        return this.actionAlignRight;
    }

    public CustomAction getActionClearFormat() {
        return this.actionClearFormat;
    }

    public StyledEditorKit.BoldAction getActionFontBold() {
        return this.actionFontBold;
    }

    public StyledEditorKit.ItalicAction getActionFontItalic() {
        return this.actionFontItalic;
    }

    public FormatAction getActionFontStrike() {
        return this.actionFontStrike;
    }

    public FormatAction getActionFontSubscript() {
        return this.actionFontSubscript;
    }

    public FormatAction getActionFontSuperscript() {
        return this.actionFontSuperscript;
    }

    public StyledEditorKit.UnderlineAction getActionFontUnderline() {
        return this.actionFontUnderline;
    }

    public IndentAction getActionIndentLeft() {
        return this.actionIndentLeft;
    }

    public IndentAction getActionIndentRight() {
        return this.actionIndentRight;
    }

    public CustomAction getActionInsertHyperlink() {
        return this.actionInsertHyperlink;
    }

    public ServerImageAction getActionInsertServerImage() {
        return this.actionInsertServerImage;
    }

    public SpecialCharAction getActionInsertCharacter() {
        return this.actionInsertCharacter;
    }

    public ListAutomationAction getActionListOrdered() {
        return this.actionListOrdered;
    }

    public ListAutomationAction getActionListUnordered() {
        return this.actionListUnordered;
    }

    public CustomAction getActionSelectFont() {
        return this.actionSelectFont;
    }

    public ToggleCaseAction getActionToggleCase() {
        return this.actionToggleCase;
    }

    public KafenioPanel.RedoAction getRedoAction() {
        return this.parent.getRedoAction();
    }

    public KafenioPanel.UndoAction getUndoAction() {
        return this.parent.getUndoAction();
    }

    public FormatAction getActionAddParagraph() {
        return this.actionAddParagraph;
    }

    public FormatAction getActionHeading1() {
        return this.actionHeading1;
    }

    public FormatAction getActionHeading2() {
        return this.actionHeading2;
    }

    public FormatAction getActionHeading3() {
        return this.actionHeading3;
    }

    public FormatAction getActionHeading4() {
        return this.actionHeading4;
    }

    public FormatAction getActionHeading5() {
        return this.actionHeading5;
    }

    public FormatAction getActionHeading6() {
        return this.actionHeading6;
    }

    public FormatAction getActionAddListItem() {
        return this.actionAddListItem;
    }

    public FormatAction getActionBlockquote() {
        return this.actionBlockquote;
    }

    public FormatAction getActionEmphasis() {
        return this.actionEmphasis;
    }

    public FormatAction getActionPre() {
        return this.actionPre;
    }

    public FormatAction getActionSpan() {
        return this.actionSpan;
    }

    public FormatAction getActionStrong() {
        return this.actionStrong;
    }

    public FormatAction getActionTT() {
        return this.actionTT;
    }

    public CustomAction getActionFontSize1() {
        return this.actionFontSize1;
    }

    public CustomAction getActionFontSize2() {
        return this.actionFontSize2;
    }

    public CustomAction getActionFontSize3() {
        return this.actionFontSize3;
    }

    public CustomAction getActionFontSize4() {
        return this.actionFontSize4;
    }

    public CustomAction getActionFontSize5() {
        return this.actionFontSize5;
    }

    public CustomAction getActionFontSize6() {
        return this.actionFontSize6;
    }

    public CustomAction getActionFontSize7() {
        return this.actionFontSize7;
    }

    public FormatAction getActionFormatBig() {
        return this.actionFormatBig;
    }

    public FormatAction getActionFormatSmall() {
        return this.actionFormatSmall;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorAqua() {
        return this.actionFontColorAqua;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorBlack() {
        return this.actionFontColorBlack;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorBlue() {
        return this.actionFontColorBlue;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorFuschia() {
        return this.actionFontColorFuschia;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorGray() {
        return this.actionFontColorGray;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorGreen() {
        return this.actionFontColorGreen;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorLime() {
        return this.actionFontColorLime;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorMaroon() {
        return this.actionFontColorMaroon;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorNavy() {
        return this.actionFontColorNavy;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorOlive() {
        return this.actionFontColorOlive;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorPurple() {
        return this.actionFontColorPurple;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorRed() {
        return this.actionFontColorRed;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorSilver() {
        return this.actionFontColorSilver;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorTeal() {
        return this.actionFontColorTeal;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorWhite() {
        return this.actionFontColorWhite;
    }

    public StyledEditorKit.ForegroundAction getActionFontColorYellow() {
        return this.actionFontColorYellow;
    }

    public CustomAction getActionFontCustomColor() {
        return this.actionFontCustomColor;
    }
}

