/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.util;

import de.xeinfach.kafenio.util.LeanLogger;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Translatrix {
    private static LeanLogger log = new LeanLogger("Translatrix.class");
    private ResourceBundle langResources;
    private String bundleName;
    private Locale locale;

    public Translatrix() {
    }

    public Translatrix(String string) {
        this.setBundleName(string);
    }

    public void setBundleName(String string) {
        this.bundleName = string;
        try {
            this.langResources = ResourceBundle.getBundle(this.bundleName);
        }
        catch (MissingResourceException missingResourceException) {
            log.error("MissingResourceException while loading language file" + missingResourceException.fillInStackTrace());
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        log.debug("setting locale to: " + this.locale);
        if (this.bundleName == null) {
            log.debug("bundle-name not set, returning null.");
            return;
        }
        if (this.locale != null) {
            try {
                this.langResources = ResourceBundle.getBundle(this.bundleName, this.locale);
            }
            catch (MissingResourceException missingResourceException) {
                try {
                    this.langResources = ResourceBundle.getBundle(this.bundleName);
                }
                catch (MissingResourceException missingResourceException2) {
                    log.error("MissingResourceException while loading language file" + missingResourceException2.fillInStackTrace());
                }
            }
        } else {
            try {
                this.langResources = ResourceBundle.getBundle(this.bundleName);
            }
            catch (MissingResourceException missingResourceException) {
                log.error("MissingResourceException while loading language file" + missingResourceException.fillInStackTrace());
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(String string, String string2) {
        if (string != null && string2 != null) {
            this.setLocale(new Locale(string, string2));
        }
    }

    public String getTranslationString(String string) {
        if (this.bundleName == null) {
            return string;
        }
        try {
            return this.langResources.getString(string);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    private void logException(String string, Exception exception) {
        System.err.println(string);
        exception.printStackTrace(System.err);
    }
}

