/*
 *  Remote Network application system for DNAS -- plugin loading routine.
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: loadplugin.c,v 1.5 2003/01/22 05:31:24 dancer Exp $
 */



#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <pthread.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <locale.h>
#include <dlfcn.h>
#include "config.h"
#include "dmachinemon/dmachinemon-debug.h"
#include "dmachinemon/dmachinemon.h"
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "rnas-monitor-gtk.h"


/**
 * Routine to load one plugin and to initialize the variables from the lisp command-line.
 *
 */
static rnasmonitors *
loadplugin(const char * itemname, rnasmonitors * m, dlisp_lispentry*l)
{
  rnasmonitors * rmon = malloc(sizeof(rnasmonitors));
  rnasmonitors * firstmon = m;
  void * dlhandle;
  int (*initialize)(rnasmonitors*);
  char * soplace = NULL;
  
  fprintf(stdout, "Loading plugin %s\n", itemname);
  asprintf (&soplace, "%s/rnasmonitor-%s.so", PKGLIBDIR, itemname);
  if (!(dlhandle = dlopen(soplace, RTLD_NOW)))
    {

      fprintf(stderr, 
	      "plugin [%s] could not be opened from [%s], dlopen failed.\n"
	      "Due to error [%s]\n"
	      , itemname, soplace,
	      dlerror());
      
      return NULL;
    }
  

  if (!(initialize=dlsym (dlhandle, "rnas_monitor_initialize")))
    {
      perror("dlopen");
      fprintf(stderr, "rnas_monitor_initialize was not found in [%s]\n"
	      "Error [%s]\n", 
	      itemname, dlerror());
      return NULL;
    }
  
  free(soplace);
  

  if (!((l->next) && (rmon->titlename = l->next->name)))
    {
      fprintf(stderr, "titlename not found on commandline for [%s]\n", itemname);
      return NULL;
    }
  if (!((l->next->next)&&(rmon->tagname = l->next->next->name)))
    {
      fprintf(stderr, "tagname not found on commandline for [%s]\n", itemname);
      return NULL;
    }
  
  rmon->l = l;
  rmon->next = NULL;

  if (initialize(rmon))
    {
      fprintf(stderr, "[%s] returned error in initialization exiting\n", itemname);
      return NULL;
    }
  if (VERIFY_RNASVERSION(rmon))
    {
      fprintf(stderr, "[%s] returned wrong interface version %i when %i was expected\n", itemname, 
	      rmon->serialversion, RNASMONITORVERSION
	      );
      return NULL;
    }

  if(!m)
    {
      return rmon;
    }
  else
    {
      while (m && m->next)
	m=m->next;
      m->next = rmon;
      return firstmon;
    }
}

/**
 * load plugins specified on the command-line.
 *
 * uses loadplugin to load individual plugin.
 *
 * @return rnas plugin pointer on success.
 */
rnasmonitors *
load_plugins(char ** av)
{
  int i;
  rnasmonitors * m = NULL;
  
  DEBUGPRINT("loadplug");
  for (i=0; av[i]; i++)
    {
      FILE*f = fmemopen (av[i], strlen(av[i]), "r");
      dlisp_lispentry * l;
      
      if (!f)
	{
	  fprintf(stderr, "weird error\n");
	  return NULL;
	}
      
      l = dlisp_read_lisp_bracket(f);
      if (!l)
	{
	  fprintf(stderr, "error in command-line option [%s]\n", av[i]);
	  return NULL;
	}
      
      fclose(f);
      if (!(m=loadplugin (l->name, m, l)))
	{
	  fprintf(stderr, "error in loadplugin\n");
	  return NULL;
	}
      DEBUGPRINT("finishone");
    }
  return m;
}
