<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                exclude-result-prefixes="doc"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: docbook.xsl,v 1.29 2004/07/16 02:00:09 stevecheng Exp $
     ********************************************************************

     &copy; 2000-2001 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Originally derived from Norman Walsh's XSL DocBook Stylesheet
     Distribution.
     
     ******************************************************************** -->

<!-- ==================================================================== -->

<!-- i18n templates -->
<xsl:include href="../common/l10n.xsl" />
<xsl:include href="../common/messages.xsl" />
<xsl:include href="../common/gentext.xsl" />

<!-- Common DocBook stuff -->
<xsl:include href="../common/cmdsynopsis.xsl" />
<xsl:include href="../common/labels.xsl" />
<xsl:include href="../common/lists.xsl" />
<xsl:include href="../common/person.xsl" />
<xsl:include href="../common/titles.xsl" />
<xsl:include href="../common/whitespace.xsl" />



<!-- Default parameters  -->
<xsl:include href="param.xsl"/>

<!-- Texinfo node handling -->
<xsl:include href="texifile.xsl" />
<xsl:include href="texinode-base.xsl" />
<xsl:include href="texinode.xsl" />
<xsl:include href="texinode-hash.xsl" />

<!-- Texinfo menus -->
<xsl:include href="autotoc.xsl"/>
<xsl:include href="menudescrip.xsl" />

<!-- Texinfo automatic indexing -->
<xsl:include href="index.xsl"/>

<!-- Sectioning -->
<xsl:include href="sectioning.xsl" />
<xsl:include href="component.xsl"/>
<xsl:include href="division.xsl"/>
<xsl:include href="sections.xsl"/>
<xsl:include href="refentry.xsl"/>

<!-- Block objects -->
<xsl:include href="admon.xsl"/>
<xsl:include href="block.xsl"/>
<xsl:include href="caption.xsl" />
<xsl:include href="formal.xsl"/>
<xsl:include href="synop.xsl"/>
<xsl:include href="verbatim.xsl"/>

<!-- Other objects -->
<xsl:include href="footnote.xsl"/>
<xsl:include href="force-inline.xsl" />
<xsl:include href="inline.xsl"/>
<xsl:include href="math.xsl"/>
<xsl:include href="qandaset.xsl"/>
<xsl:include href="table.xsl"/>

<!-- Cross references -->
<xsl:include href="xref.xsl"/>

<!-- Lists -->
<xsl:include href="glossary.xsl"/>
<xsl:include href="lists.xsl"/>

<!-- Graphics -->
<xsl:include href="callout.xsl"/>
<xsl:include href="graphics.xsl"/>

<!-- Metadata -->
<xsl:include href="biblio.xsl"/>
<xsl:include href="info.xsl"/>
<xsl:include href="keywords.xsl"/>
<xsl:include href="toc.xsl"/>

<!-- Page layout -->
<xsl:include href="beginpage.xsl" />

<!-- Processing instructions -->
<xsl:include href="pi.xsl"/>

<!-- ==================================================================== -->

<xsl:output method="xml" encoding="utf-8" />

<!-- ==================================================================== -->

<xsl:key name="id" match="*[@id]" use="@id" />

<!-- ==================================================================== -->

<xsl:template match="*">
  <xsl:call-template name="user-message">
    <xsl:with-param name="key">Element not matched by any template</xsl:with-param>
  </xsl:call-template>

  <xsl:comment>
    <xsl:call-template name="gentext-rendering">
      <xsl:with-param name="key" select="'element-not-matched'" />
      <xsl:with-param name="content" select="name(.)" />
    </xsl:call-template>
  </xsl:comment>

  <xsl:apply-templates />
</xsl:template>

<xsl:template match="text()">
  <xsl:value-of select="."/> 
</xsl:template>

<!-- ==================================================================== -->

<doc:reference xmlns="">
<title>Texinfo XSLT stylesheets driver</title>
<partintro>

<para>
This file is the basic driver of the Texinfo XSLT stylesheets.  It
includes all the other stylesheet files.
</para>

<para>
The Texinfo XSLT stylesheets require a non-standard hashtable extension
to properly handle the Texinfo node functionality.  For portability's
sake, this driver file does <emphasis>not</emphasis> use these
extensions, but its output will often be suboptimal.  Therefore, you
should use another driver such as <filename
role="xsl-file">docbook-java.xsl </filename> or <filename
role="xsl-file">docbook-libxslt.xsl</filename>, depending on which XSLT
processor you are using the stylesheets with.
</para>

<para>
You can use this stylesheet directly, or create your own custom
stylesheet that imports this one (or one of the other driver files):

<example>
<title>Importing stylesheets</title>

<programlisting><![CDATA[
<xsl:import href="docbook.xsl" />]]>
</programlisting>
</example>

Importing the stylesheet allows you to specify stylesheet options and
customize the stylesheets without changing the standard stylesheets.
</para>
</partintro>
</doc:reference>

</xsl:stylesheet>
