<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: formal.xsl,v 1.9 2004/07/15 20:09:10 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Derived from files in Norman Walsh's XSL DocBook Stylesheet
     Distribution and Mark Burton's dbtotexi stylesheets.

     ******************************************************************** -->

<xsl:template name="formal-object">
  <xsl:call-template name="anchor" />
  
  <xsl:call-template name="make-caption">
    <xsl:with-param name="content">
      <xsl:apply-templates select="title" mode="title" />
    </xsl:with-param>
  </xsl:call-template>
  <xsl:apply-templates />
</xsl:template>

<xsl:template name="informal-object">
  <xsl:call-template name="anchor" />
  <xsl:apply-templates/>
</xsl:template>

<xsl:template name="semiformal-object">
  <xsl:choose>
    <xsl:when test="title">
      <xsl:call-template name="formal-object"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="informal-object"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="figure|table|example">
  <xsl:call-template name="formal-object"/>
</xsl:template>

<xsl:template match="equation">
  <xsl:call-template name="semiformal-object"/>
</xsl:template>

<xsl:template match="informalfigure">
  <xsl:call-template name="informal-object"/>
</xsl:template>

<xsl:template match="informalexample">
  <xsl:call-template name="informal-object"/>
</xsl:template>

<xsl:template match="informaltable">
  <xsl:call-template name="informal-object"/>
</xsl:template>

<xsl:template match="informalequation">
  <xsl:call-template name="informal-object"/>
</xsl:template>

</xsl:stylesheet>
