/* BTP library - Banana Tree Protocol
 * Copyright (C) 1999-2001  The Regents of the University of Michigan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#ifndef _B_CONN_PING_H
#define _B_CONN_PING_H

#include "b_conn.h"

#define BTP_PING_SEND_TIME	 5000	/* Ping rate          		*/
#define BTP_PING_SEND_RANGE	 2000	/* Ping rate variance 		*/
#define BTP_PING_AVG_FACTOR	0.875	/* new = old * F + ping * (1-F) */
#define BTP_PING_TIMEOUT	90000	/* Connection timeout 		*/

void	 b_conn_ping_start (BConn* conn);
void	 b_conn_ping_stop  (BConn* conn);

void	 b_conn_ping_send (BConn* conn);

void	 b_conn_ping_handle (BConn* conn);
void	 b_conn_ping_unhandle (BConn* conn);

#endif /* _B_CONN_PING_H */
