#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "../include/string.h"

#include "guiutils.h"

#include "tlist.h"
#include "edvlistseek.h"


gboolean EDVCListSeekCharacter(
	GtkCList *clist, gint column, gint cidx, gchar c
);
gboolean EDVTListSeekCharacter(
	tlist_struct *tlist, gint cidx, gchar c
);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Searches all cells of the given clist on the specified column
 *	who has the character at index cidx that matches c.
 *
 *	If a match is made, then the clist will be scrolled to the
 *	position of the first match and the return will be TRUE.
 */
gboolean EDVCListSeekCharacter(
	GtkCList *clist, gint column, gint cidx, gchar c
)
{
	gint row;
	gchar *text;
	guint8 spacing;
	GdkBitmap *mask;
	GdkPixmap *pixmap;


	if((clist == NULL) || (cidx < 0))
	    return(FALSE);

	if((column < 0) || (column >= clist->columns))
	    return(FALSE);

	/* Iterate through all rows on the clist */
	for(row = 0; row < clist->rows; row++)
	{
	    /* Handle by cell type */
	    text = NULL;
	    switch(gtk_clist_get_cell_type(clist, row, column))
	    {
	      case GTK_CELL_TEXT:
		gtk_clist_get_text(
		    clist, row, column, &text
		);
		break;
	      case GTK_CELL_PIXTEXT:
		gtk_clist_get_pixtext(
		    clist, row, column, &text,
		    &spacing, &pixmap, &mask
		);
		break;
	      case GTK_CELL_PIXMAP:
	      case GTK_CELL_WIDGET:
	      case GTK_CELL_EMPTY:
		break;
	    }
	    /* Got pointer to text in current cell? */
	    if(!STRISEMPTY(text))
	    {
		gint len = STRLEN(text);

		/* Length of cell text long enough to check for
		 * character index?
		 */
		if(cidx < len)
		{
		    /* Length of cell text is allocated long enough, now
		     * check if the character of the cell text at index
		     * cidx matches the given character
		     */
		    if(text[cidx] == c)
		    {
			/* Got a match, scroll to this row */
			gtk_clist_moveto(
			    clist,
			    row, column,	/* Row, column */
			    0.5f, 0.0f		/* Row, column */
			);
			return(TRUE);
		    }
		}
	    }
	}

	return(FALSE);
}

/*
 *      Searches all thumbs of the given tlist who has a the character
 *      at index cidx that matches c.
 *
 *      If a match is made, then the tlist will be scrolled to the
 *      position of the first match and the return will be TRUE.
 */
gboolean EDVTListSeekCharacter(
	tlist_struct *tlist, gint cidx, gchar c
)
{
	const gchar *text;
	gint i;
	tlist_thumb_struct *thumb_ptr;


	if((tlist == NULL) || (cidx < 0))
	    return(FALSE);


	/* Iterate through all thumbs */
	for(i = 0; i < tlist->total_thumbs; i++)
	{
	    thumb_ptr = tlist->thumb[i];
	    if(thumb_ptr == NULL)
		continue;

	    text = thumb_ptr->text;

	    /* Got pointer to text in current thumb? */
	    if(!STRISEMPTY(text))
	    {
		gint len = STRLEN(text);

		/* Length of thumb text long enough to check for
		 * character index?
		 */
		if(cidx < len)
		{
		    /* Length of thumb text is allocated long enough, now
		     * check if the character of the thumb text at index
		     * cidx matches the given character
		     */
		    if(text[cidx] == c)
		    {
			/* Got a match, scroll to this thumb */
			TListMoveTo(tlist, i, 0.5f);
			return(TRUE);
		    }
		}
	    }
	}

	return(FALSE);
}
