/* 
 * Java binding for Entity
 *
 * Author: Doug McBride <dougm@liberate.com>
 * based on renderers/javascript/js-embed.h by Brian Bassett <bbassett@bbassett.net>
 *
 */

/* 
 * This renderer is free software; please see the LICENSE file for
 * specific information as to licensing conditions.
 */

/* 
 * $Source: /home/cvs/entity/renderers/java/java-embed.h,v $
 * $Id: java-embed.h,v 1.1 2001/05/01 00:21:44 giantpez Exp $
 */

#ifndef __EMBED_JAVA_H__
#define __EMBED_JAVA_H__

#include "entity.h"
#include <jni.h>
#include <jni_md.h>

/* Our renderer entry function */
void java_init (RendererFlags flags);

/*
 *  * Pointers to the needed JNI invocation API, initialized by LoadJavaVM.
 *   */
typedef jint (JNICALL *CreateJavaVM_t)(JavaVM **pvm, void **env, void *args);
typedef jint (JNICALL *GetDefaultJavaVMInitArgs_t)(void *args);

typedef struct {
    CreateJavaVM_t CreateJavaVM;
    GetDefaultJavaVMInitArgs_t GetDefaultJavaVMInitArgs;
} InvocationFunctions;


/* XXX don't understand what this is for yet, not implemented (JS handling code)
 * void js_Entity_ENode (JAVAVirtualMachine * js_vm);
 */

#endif				/* __EMBED_JAVA_H__ */
