#ifndef SERVER_H
#define SERVER_H

#ifndef GNOME_H
#include <gnome.h>
#endif
#ifndef TASKS_H
#include "tasks.h"
#endif
#ifndef BOOKMARKS_H
#include "bookmarks.h"
#endif
#ifndef THREADS_H
#include "threads.h"
#endif

typedef struct {
  GnomeUIInfo *toolbar_info;
  GtkWidget *main_window;
  GtkWidget *notebook;
  GtkWidget *hbox;
} ConnectionGui;

typedef struct _connection {
  Bookmark *bookmark;
  FILE *infd,*outfd;
  Task *task;
  int end_count;
  int version;
  Thread thread_in,thread_out;
  pthread_cond_t *signal;
  pthread_mutex_t *mutex;
  GList *proclist;
  GList *replies_pending;
  GList *hooks;
  ConnectionGui *gui;
} Connection;

extern GSList *connections_list;

typedef void (*STransFunc)(Connection *, gpointer); 

#define S_NAME(c) (strlen(c->bookmark->name) ? c->bookmark->name:c->bookmark->host)
Task *task_new_sname(const Connection *c);

void hooks_create(Connection *c,char *name,gpointer data,
		void (*create)(Connection *),
		STransFunc destroy);
void hooks_set_data(Connection *c,char *name,gpointer data);
gpointer hooks_get_data(Connection *c,char *name);

void server_connect_to(Bookmark *b);
void server_transaction_start(Connection *c,
			      STransFunc start,
			      gpointer data);
void server_cancel(Connection *c);

void forall_servers(STransFunc,gpointer);

#endif
