//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: VTKDriver.hpp,v 1.1.1.1 2003/02/17 16:32:50 delpinux Exp $

#ifndef VTKDRIVER_HPP
#define VTKDRIVER_HPP

/**
 * @file   VTKDriver.hpp
 * @author Stephane Del Pino
 * @date   Sat Nov 16 14:33:13 2002
 * 
 * @brief  A first attempt to VTK management inside ff3d
 * 
 * 
 */

#include <config.h>

class Mesh;

class MeshOfHexahedra;

class SurfaceMeshOfTriangles;

class VTKDriver
{
private:
  template <typename MeshType>
  void __plotMesh(const MeshType& m);

public:
#ifdef HAVE_LIBVTK
  void plotMesh(const Mesh& m);
#else // HAVE_LIBVTK
  void plotMesh(const Mesh& m)
  {
    fferr(0) << "Warning: cannot call this function, your version does not support VTK!\n";
  }
#endif // HAVE_LIBVTK

  VTKDriver()
  {
    ;
  }

  ~VTKDriver()
  {
    ;
  }
};

#endif // VTKDRIVER_HPP
